/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.PriorityBlockingQueue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class CollectionCloningCleanUpCore
extends AbstractMultiFix {
    public CollectionCloningCleanUpCore() {
        this(Collections.emptyMap());
    }

    public CollectionCloningCleanUpCore(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.collection_cloning");
        return new CleanUpRequirements(requireAST, false, false, null);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.collection_cloning")) {
            return new String[]{MultiFixMessages.CollectionCloningCleanUp_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.collection_cloning")) {
            return "List<Integer> output = new ArrayList<>(collection);\n\n";
        }
        return "List<Integer> output = new ArrayList<>();\noutput.addAll(collection);\n";
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit) throws CoreException {
        if (!this.isEnabled("cleanup.collection_cloning")) {
            return null;
        }
        final ArrayList rewriteOperations = new ArrayList();
        unit.accept(new ASTVisitor(){

            public boolean visit(Block node) {
                NewAndAddAllMethodVisitor newAndAddAllMethodVisitor = new NewAndAddAllMethodVisitor(node, rewriteOperations);
                node.accept((ASTVisitor)newAndAddAllMethodVisitor);
                return newAndAddAllMethodVisitor.result;
            }

            final class NewAndAddAllMethodVisitor
            extends ASTVisitor {
                private final Block startNode;
                private boolean result = true;
                private final /* synthetic */ List val$rewriteOperations;

                public NewAndAddAllMethodVisitor(Block startNode, List list) {
                    this.val$rewriteOperations = list;
                    this.startNode = startNode;
                }

                public boolean visit(Block node) {
                    return this.startNode == node;
                }

                public boolean visit(ExpressionStatement node) {
                    MethodInvocation methodInvocation = ASTNodes.asExpression((Statement)node, MethodInvocation.class);
                    if (this.result && ASTNodes.usesGivenSignature(methodInvocation, Collection.class.getCanonicalName(), "addAll", Collection.class.getCanonicalName())) {
                        Expression arg0 = (Expression)methodInvocation.arguments().get(0);
                        Statement previousStatement = ASTNodes.getPreviousSibling((Statement)node);
                        Assignment as = ASTNodes.asExpression(previousStatement, Assignment.class);
                        VariableDeclarationFragment fragment = ASTNodes.getUniqueFragment(previousStatement);
                        if (ASTNodes.hasOperator(as, Assignment.Operator.ASSIGN, new Assignment.Operator[0])) {
                            SimpleName lhs = ASTNodes.as(as.getLeftHandSide(), SimpleName.class);
                            if (lhs != null && ASTNodes.isSameLocalVariable((Expression)lhs, methodInvocation.getExpression())) {
                                return this.maybeReplaceInitializer(as.getRightHandSide(), arg0, node);
                            }
                        } else if (fragment != null && ASTNodes.isSameLocalVariable((VariableDeclaration)fragment, methodInvocation.getExpression())) {
                            return this.maybeReplaceInitializer(fragment.getInitializer(), arg0, node);
                        }
                    }
                    return true;
                }

                private boolean maybeReplaceInitializer(Expression nodeToReplace, Expression arg0, ExpressionStatement nodeToRemove) {
                    ClassInstanceCreation cic = ASTNodes.as(nodeToReplace, ClassInstanceCreation.class);
                    if (this.canReplaceInitializer(cic, arg0) && ASTNodes.isCastCompatible(nodeToReplace, arg0)) {
                        this.val$rewriteOperations.add(new CollectionCloningOperation(nodeToRemove, cic, arg0));
                        this.result = false;
                        return false;
                    }
                    return true;
                }

                private boolean canReplaceInitializer(ClassInstanceCreation cic, Expression sourceCollection) {
                    if (cic == null || cic.getAnonymousClassDeclaration() != null) {
                        return false;
                    }
                    if (cic.arguments().isEmpty()) {
                        return ASTNodes.hasType((Expression)cic, ConcurrentLinkedDeque.class.getCanonicalName(), ArrayList.class.getCanonicalName(), HashSet.class.getCanonicalName(), LinkedHashSet.class.getCanonicalName(), LinkedList.class.getCanonicalName(), TreeSet.class.getCanonicalName(), Vector.class.getCanonicalName(), ConcurrentLinkedQueue.class.getCanonicalName(), ConcurrentSkipListSet.class.getCanonicalName(), CopyOnWriteArrayList.class.getCanonicalName(), CopyOnWriteArraySet.class.getCanonicalName(), DelayQueue.class.getCanonicalName(), LinkedBlockingDeque.class.getCanonicalName(), LinkedBlockingQueue.class.getCanonicalName(), LinkedTransferQueue.class.getCanonicalName(), PriorityBlockingQueue.class.getCanonicalName(), ArrayDeque.class.getCanonicalName(), PriorityQueue.class.getCanonicalName());
                    }
                    return this.isValidCapacityParameter(sourceCollection, cic.arguments()) && ASTNodes.hasType((Expression)cic, ArrayList.class.getCanonicalName(), HashSet.class.getCanonicalName(), LinkedHashSet.class.getCanonicalName(), LinkedBlockingDeque.class.getCanonicalName(), LinkedBlockingQueue.class.getCanonicalName(), PriorityBlockingQueue.class.getCanonicalName(), ArrayDeque.class.getCanonicalName(), PriorityQueue.class.getCanonicalName(), Vector.class.getCanonicalName());
                }

                private boolean isValidCapacityParameter(Expression sourceCollection, List<Expression> args) {
                    if (args.size() == 1 && ASTNodes.isPrimitive(args.get(0), Integer.TYPE.getSimpleName())) {
                        Long constant = ASTNodes.getIntegerLiteral(args.get(0));
                        if (constant != null) {
                            return Long.valueOf(0L).equals(constant);
                        }
                        MethodInvocation methodInvocation = ASTNodes.as(args.get(0), MethodInvocation.class);
                        return ASTNodes.usesGivenSignature(methodInvocation, Collection.class.getCanonicalName(), "size", new String[0]) && ASTNodes.match((ASTNode)methodInvocation.getExpression(), (ASTNode)sourceCollection);
                    }
                    return false;
                }
            }
        });
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.CollectionCloningCleanUp_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange[0]));
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        return false;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    private static class CollectionCloningOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange {
        private final ExpressionStatement nodeToRemove;
        private final ClassInstanceCreation classInstanceCreation;
        private final Expression arg0;

        public CollectionCloningOperation(ExpressionStatement nodeToRemove, ClassInstanceCreation classInstanceCreation, Expression arg0) {
            this.nodeToRemove = nodeToRemove;
            this.classInstanceCreation = classInstanceCreation;
            this.arg0 = arg0;
        }

        @Override
        public void rewriteASTInternal(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)this.classInstanceCreation, ClassInstanceCreation.ARGUMENTS_PROPERTY);
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.CollectionCloningCleanUp_description, cuRewrite);
            if (this.classInstanceCreation.arguments() == null || this.classInstanceCreation.arguments().isEmpty()) {
                listRewrite.insertFirst((ASTNode)ASTNodes.createMoveTarget(rewrite, this.arg0), group);
            } else {
                listRewrite.replace((ASTNode)this.classInstanceCreation.arguments().get(0), (ASTNode)ASTNodes.createMoveTarget(rewrite, this.arg0), group);
            }
            rewrite.remove((ASTNode)this.nodeToRemove, group);
        }
    }
}

