/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class SaveComparisonModelAction
extends Action {
    private static final ImmutableList<String> DIALOG_BUTTON_LABELS = ImmutableList.of((Object)EMFCompareIDEUIMessages.getString("save.model.replace"), (Object)EMFCompareIDEUIMessages.getString("save.model.cancel"));
    private IEMFCompareConfiguration configuration;

    public SaveComparisonModelAction(IEMFCompareConfiguration configuration) {
        this.configuration = configuration;
        this.setToolTipText(EMFCompareIDEUIMessages.getString("save.model.tooltip"));
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/saveas_edit.gif"));
    }

    public void run() {
        Shell parent = this.getShell();
        FileDialog fileDialog = new FileDialog(parent, 8192);
        String filePath = fileDialog.open();
        if (filePath != null) {
            File file = new File(filePath);
            if (file.exists()) {
                MessageDialog messageDialog = new MessageDialog(parent, EMFCompareIDEUIMessages.getString("save.model.fileExistsTitle"), null, EMFCompareIDEUIMessages.getString("save.model.fileExistsMsg", file), 4, (String[])DIALOG_BUTTON_LABELS.toArray((Object[])new String[DIALOG_BUTTON_LABELS.size()]), 1);
                int open = messageDialog.open();
                if (open == DIALOG_BUTTON_LABELS.indexOf((Object)EMFCompareIDEUIMessages.getString("save.model.replace"))) {
                    this.saveComparison(file);
                    this.refreshLocation(filePath);
                }
            } else {
                this.saveComparison(file);
                this.refreshLocation(filePath);
            }
        }
        super.run();
    }

    private Shell getShell() {
        if (PlatformUI.isWorkbenchRunning()) {
            return PlatformUI.getWorkbench().getDisplay().getActiveShell();
        }
        return Display.getDefault().getActiveShell();
    }

    public boolean isEnabled() {
        return this.configuration.isLeftEditable() && this.configuration.isRightEditable();
    }

    private void saveComparison(File file) {
        Comparison comparison = this.configuration.getComparison();
        XMIResourceImpl resource = new XMIResourceImpl(URI.createFileURI((String)file.getAbsolutePath()));
        EcoreUtil.Copier copier = new EcoreUtil.Copier(false);
        EObject comparisonCopy = copier.copy((EObject)comparison);
        copier.copyReferences();
        resource.getContents().add((Object)comparisonCopy);
        try {
            resource.save((Map)Maps.newHashMap());
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof NotSerializableException) {
                Status status = new Status(4, "org.eclipse.emf.compare.ide.ui", EMFCompareIDEUIMessages.getString("resource.not.serializable"), (Throwable)e);
                StatusManager.getManager().handle(new StatusAdapter((IStatus)status), 2);
            } else {
                EMFCompareIDEUIPlugin.getDefault().log(e);
            }
        }
        catch (IOException e) {
            EMFCompareIDEUIPlugin.getDefault().log(e);
        }
    }

    private void refreshLocation(String path) {
        try {
            IFile fileForLocation = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(path));
            if (fileForLocation != null) {
                fileForLocation.getParent().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            EMFCompareIDEUIPlugin.getDefault().log(e);
        }
    }
}

