/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.security;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.function.Function;
import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.factory.SingletonFactory;
import org.eclipse.net4j.util.security.ICrypter;
import org.eclipse.net4j.util.security.MessageDigestCrypter;

public final class Crypter
implements ICrypter {
    private final String type;
    private final String params;
    private final Function<byte[], byte[]> function;

    public Crypter(String type, String params, Function<byte[], byte[]> function) {
        this.type = type;
        this.params = params;
        this.function = function;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getParams() {
        return this.params;
    }

    @Override
    public byte[] apply(byte[] data) {
        return this.function.apply(data);
    }

    public static final class MetaFactory
    extends org.eclipse.net4j.util.factory.MetaFactory {
        private static final String PG = "org.eclipse.net4j.util.security.crypters";
        private static final IFactory[] CHILDREN = MetaFactory.createChildren();

        public MetaFactory() {
            super(PG);
        }

        @Override
        public IFactory[] create(String description) throws ProductCreationException {
            return CHILDREN;
        }

        private static IFactory[] createChildren() {
            ArrayList<Factory> children = new ArrayList<Factory>();
            children.add(new SingletonFactory(PG, IDENTITY.getType(), IDENTITY));
            Provider[] providerArray = Security.getProviders();
            int n = providerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Provider provider = providerArray[n2];
                for (Provider.Service service : provider.getServices()) {
                    String type = service.getType();
                    if (!type.equals("MessageDigest")) continue;
                    final String algorithm = service.getAlgorithm();
                    children.add(new Factory(PG, algorithm){

                        @Override
                        public Object create(String params) throws ProductCreationException {
                            try {
                                return new MessageDigestCrypter(algorithm, params);
                            }
                            catch (NoSuchAlgorithmException ex) {
                                throw new ProductCreationException(ex);
                            }
                        }
                    });
                }
                ++n2;
            }
            return children.toArray(new IFactory[children.size()]);
        }
    }
}

