/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.fsm;

import java.io.PrintStream;
import java.text.MessageFormat;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.fsm.ITransition;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class FiniteStateMachine<STATE extends Enum<?>, EVENT extends Enum<?>, SUBJECT>
extends Lifecycle {
    public static final ITransition IGNORE = new InternalIgnoreTransition();
    public static final ITransition FAIL = new InternalFailTransition();
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, FiniteStateMachine.class);
    private static final String MSG_PROCESS = "Processing event {0} in state {1} for {2} (data={3})";
    private static final String MSG_IGNORE = "Ignoring event {0} in state {1} for {2} (data={3})";
    private static final String MSG_FAIL = "Failing event {0} in state {1} for {2} (data={3})";
    private STATE[] states;
    private EVENT[] events;
    private ITransition<STATE, EVENT, SUBJECT, ?>[][] transitions;

    public FiniteStateMachine(Class<STATE> stateEnum, Class<EVENT> eventEnum, ITransition<STATE, EVENT, SUBJECT, ?> defaultTransition) {
        this.states = (Enum[])stateEnum.getEnumConstants();
        this.events = (Enum[])eventEnum.getEnumConstants();
        this.transitions = new ITransition[this.states.length][this.events.length];
        this.initAll(defaultTransition);
    }

    public FiniteStateMachine(Class<STATE> stateEnum, Class<EVENT> eventEnum) {
        this(stateEnum, eventEnum, FAIL);
    }

    public final STATE[] getStates() {
        return this.states;
    }

    public final EVENT[] getEvents() {
        return this.events;
    }

    public final ITransition<STATE, EVENT, SUBJECT, ?> getTransition(STATE state, EVENT event) {
        int s = ((Enum)state).ordinal();
        int e = ((Enum)event).ordinal();
        return this.transitions[s][e];
    }

    public final void init(STATE state, EVENT event, STATE targetState) {
        this.init(state, event, new ChangeStateTransition(this, targetState));
    }

    public final void init(STATE state, EVENT event, ITransition<STATE, EVENT, SUBJECT, ?> transition) {
        this.checkTransition(transition);
        int s = ((Enum)state).ordinal();
        int e = ((Enum)event).ordinal();
        this.transitions[s][e] = transition;
    }

    public final void initEvents(STATE state, STATE targetState) {
        this.initEvents(state, new ChangeStateTransition(this, targetState));
    }

    public final void initEvents(STATE state, ITransition<STATE, EVENT, SUBJECT, ?> transition) {
        this.checkTransition(transition);
        int s = ((Enum)state).ordinal();
        int e = 0;
        while (e < this.events.length) {
            this.transitions[s][e] = transition;
            ++e;
        }
    }

    public final void initStates(EVENT event, STATE targetState) {
        this.initStates(event, new ChangeStateTransition(this, targetState));
    }

    public final void initStates(EVENT event, ITransition<STATE, EVENT, SUBJECT, ?> transition) {
        this.checkTransition(transition);
        int e = ((Enum)event).ordinal();
        int s = 0;
        while (s < this.states.length) {
            this.transitions[s][e] = transition;
            ++s;
        }
    }

    public final void initAll(STATE targetState) {
        this.initAll(new ChangeStateTransition(this, targetState));
    }

    public final void initAll(ITransition<STATE, EVENT, SUBJECT, ?> transition) {
        this.checkTransition(transition);
        int s = 0;
        while (s < this.states.length) {
            int e = 0;
            while (e < this.events.length) {
                this.transitions[s][e] = transition;
                ++e;
            }
            ++s;
        }
    }

    public final <DATA> void process(SUBJECT subject, EVENT event, DATA data) {
        int e;
        STATE state = this.getState(subject);
        int s = ((Enum)state).ordinal();
        ITransition<STATE, EVENT, SUBJECT, ?> transition = this.transitions[s][e = ((Enum)event).ordinal()];
        if (transition != IGNORE) {
            if (transition == FAIL) {
                throw new IllegalStateException(this.formatFailMessage(subject, state, event, data));
            }
            if (TRACER.isEnabled()) {
                TRACER.trace(this.formatProcessMessage(subject, state, event, data));
            }
            transition.execute(subject, state, event, data);
        }
    }

    public void dump(PrintStream out) {
        out.println(this.getClass().getSimpleName());
        STATE[] STATEArray = this.states;
        int n = this.states.length;
        int n2 = 0;
        while (n2 < n) {
            STATE state = STATEArray[n2];
            out.println("  " + state);
            EVENT[] EVENTArray = this.events;
            int n3 = this.events.length;
            int n4 = 0;
            while (n4 < n3) {
                EVENT event = EVENTArray[n4];
                System.out.print("    " + event + " --> ");
                int s = ((Enum)state).ordinal();
                int e = ((Enum)event).ordinal();
                ITransition<STATE, EVENT, SUBJECT, ?> transition = this.transitions[s][e];
                if (transition == IGNORE) {
                    System.out.println("IGNORE");
                } else if (transition == FAIL) {
                    System.out.println("FAIL");
                } else {
                    System.out.println(transition.getClass().getSimpleName());
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected ITransition<STATE, EVENT, SUBJECT, ?> createIgnoreTransition(STATE state, EVENT event) {
        return IGNORE;
    }

    protected ITransition<STATE, EVENT, SUBJECT, ?> createFailTransition(STATE state, EVENT event) {
        return FAIL;
    }

    protected String formatProcessMessage(SUBJECT subject, STATE state, EVENT event, Object data) {
        return MessageFormat.format(MSG_PROCESS, event, state, subject, data);
    }

    protected String formatIgnoreMessage(SUBJECT subject, STATE state, EVENT event, Object data) {
        return MessageFormat.format(MSG_IGNORE, event, state, subject, data);
    }

    protected String formatFailMessage(SUBJECT subject, STATE state, EVENT event, Object data) {
        return MessageFormat.format(MSG_FAIL, event, state, subject, data);
    }

    protected abstract STATE getState(SUBJECT var1);

    protected abstract void setState(SUBJECT var1, STATE var2);

    protected STATE changeState(SUBJECT subject, STATE state) {
        STATE oldState = this.getState(subject);
        if (oldState != state) {
            this.setState(subject, state);
            IListener[] listeners = this.getListeners();
            if (listeners.length != 0) {
                this.fireEvent(new StateChangedEvent(subject, (Enum<?>)oldState, (Enum<?>)state), listeners);
            }
            return oldState;
        }
        return null;
    }

    private void checkTransition(ITransition<STATE, EVENT, SUBJECT, ?> transition) {
        if (transition == null) {
            throw new IllegalArgumentException("transition == null");
        }
    }

    public static class ChangeStateTransition
    implements ITransition<STATE, EVENT, SUBJECT, Object> {
        private STATE targetState;
        final /* synthetic */ FiniteStateMachine this$0;

        public ChangeStateTransition(STATE targetState) {
            this.this$0 = var1_1;
            this.targetState = targetState;
        }

        public STATE getTargetState() {
            return this.targetState;
        }

        @Override
        public void execute(SUBJECT subject, STATE state, EVENT event, Object data) {
            this.this$0.changeState(subject, this.targetState);
        }

        public String toString() {
            return MessageFormat.format("CHANGE_STATE[{0}]", this.targetState);
        }
    }

    @Deprecated
    public static class FailTransition
    implements ITransition<Enum<?>, Enum<?>, Object, Object> {
        @Override
        public void execute(Object subject, Enum<?> state, Enum<?> event, Object data) {
        }

        public String toString() {
            return "FAIL";
        }
    }

    @Deprecated
    public static class IgnoreTransition
    implements ITransition<Enum<?>, Enum<?>, Object, Object> {
        @Override
        public void execute(Object subject, Enum<?> state, Enum<?> event, Object data) {
        }

        public String toString() {
            return "IGNORE";
        }
    }

    private static class InternalFailTransition
    implements ITransition<Enum<?>, Enum<?>, Object, Object> {
        private InternalFailTransition() {
        }

        @Override
        public void execute(Object subject, Enum<?> state, Enum<?> event, Object data) {
        }

        public String toString() {
            return "FAIL";
        }
    }

    private static class InternalIgnoreTransition
    implements ITransition<Enum<?>, Enum<?>, Object, Object> {
        private InternalIgnoreTransition() {
        }

        @Override
        public void execute(Object subject, Enum<?> state, Enum<?> event, Object data) {
        }

        public String toString() {
            return "IGNORE";
        }
    }

    public class StateChangedEvent
    implements IEvent {
        private Object subject;
        private Enum<?> oldState;
        private Enum<?> newState;

        public StateChangedEvent(Object subject, Enum<?> oldState, Enum<?> newState) {
            this.subject = subject;
            this.oldState = oldState;
            this.newState = newState;
        }

        @Override
        public INotifier getSource() {
            return FiniteStateMachine.this;
        }

        public Object getSubject() {
            return this.subject;
        }

        public Enum<?> getOldState() {
            return this.oldState;
        }

        public Enum<?> getNewState() {
            return this.newState;
        }
    }
}

