/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.preference;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RadioGroupFieldEditorWithHelp
extends FieldEditor {
    public static final String ICONS_PREFERENCES_HELP = "icons/full/others/prefshelp.gif";
    private String[][] labelsAndValues;
    private String[] tooltips;
    private int numColumns;
    private int indent = 8;
    private String value;
    private Composite radioBox;
    private Button[] radioButtons;
    private Label[] tooltipImages;
    private boolean useGroup;

    protected RadioGroupFieldEditorWithHelp() {
    }

    public RadioGroupFieldEditorWithHelp(String name, String labelText, int numColumns, String[][] labelAndValues, String[] tooltips, Composite parent) {
        this(name, labelText, numColumns, labelAndValues, tooltips, parent, false);
    }

    public RadioGroupFieldEditorWithHelp(String name, String labelText, int numColumns, String[][] labelAndValues, String[] tooltips, Composite parent, boolean useGroup) {
        this.init(name, labelText);
        Assert.isTrue((boolean)RadioGroupFieldEditorWithHelp.checkArray(labelAndValues));
        Assert.isTrue((labelAndValues != null && tooltips != null && tooltips.length == labelAndValues.length ? 1 : 0) != 0);
        this.labelsAndValues = labelAndValues;
        this.tooltips = tooltips;
        this.numColumns = numColumns + 1;
        this.useGroup = useGroup;
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numOfColumns) {
        Label control = this.getLabelControl();
        if (control != null) {
            ((GridData)control.getLayoutData()).horizontalSpan = numOfColumns;
        }
        ((GridData)this.radioBox.getLayoutData()).horizontalSpan = numOfColumns;
    }

    private static boolean checkArray(String[][] table) {
        if (table == null) {
            return false;
        }
        String[][] stringArray = table;
        int n = table.length;
        int n2 = 0;
        while (n2 < n) {
            String[] array = stringArray[n2];
            if (array == null || array.length < 2) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void doFillIntoGrid(Composite parent, int numOfColumns) {
        if (this.useGroup) {
            Composite control = this.getRadioBoxControl(parent);
            GridData gd = new GridData(768);
            control.setLayoutData((Object)gd);
        } else {
            Label control = this.getLabelControl(parent);
            GridData gd = new GridData();
            gd.horizontalSpan = numOfColumns;
            control.setLayoutData((Object)gd);
            control = this.getRadioBoxControl(parent);
            gd = new GridData();
            gd.horizontalSpan = numOfColumns;
            gd.horizontalIndent = this.indent;
            control.setLayoutData((Object)gd);
        }
    }

    protected void doLoad() {
        this.updateValue(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        this.updateValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    protected void doStore() {
        if (this.value == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.value);
    }

    public String getSelectionValue() {
        return this.value;
    }

    public int getNumberOfControls() {
        return 1;
    }

    public Composite getRadioBoxControl(Composite parent) {
        if (this.radioBox == null) {
            Font font = parent.getFont();
            if (this.useGroup) {
                Group group = new Group(parent, 0);
                group.setFont(font);
                String text = this.getLabelText();
                if (text != null) {
                    group.setText(text);
                }
                this.radioBox = group;
                GridLayout layout = new GridLayout();
                layout.horizontalSpacing = 8;
                layout.numColumns = this.numColumns;
                this.radioBox.setLayout((Layout)layout);
            } else {
                this.radioBox = new Composite(parent, 0);
                GridLayout layout = new GridLayout();
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                layout.horizontalSpacing = 8;
                layout.numColumns = this.numColumns;
                this.radioBox.setLayout((Layout)layout);
                this.radioBox.setFont(font);
            }
            this.radioButtons = new Button[this.labelsAndValues.length];
            this.tooltipImages = new Label[this.tooltips.length];
            int i = 0;
            while (i < this.labelsAndValues.length) {
                Label tooltipImage;
                Button radio;
                this.radioButtons[i] = radio = new Button(this.radioBox, 16400);
                String[] labelAndValue = this.labelsAndValues[i];
                radio.setText(labelAndValue[0]);
                radio.setData((Object)labelAndValue[1]);
                radio.setFont(font);
                radio.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
                    String oldValue = this.value;
                    this.value = (String)event.widget.getData();
                    this.setPresentsDefaultValue(false);
                    this.fireValueChanged("field_editor_value", oldValue, this.value);
                }));
                this.tooltipImages[i] = tooltipImage = new Label(this.radioBox, 0);
                tooltipImage.setImage(this.getHelpIcon());
                tooltipImage.setToolTipText(this.tooltips[i]);
                GridData gd = new GridData();
                gd.horizontalSpan = 1;
                gd.grabExcessHorizontalSpace = true;
                tooltipImage.setLayoutData((Object)gd);
                ++i;
            }
            this.radioBox.addDisposeListener(event -> {
                this.radioBox = null;
                this.radioButtons = null;
            });
        } else {
            this.checkParent((Control)this.radioBox, parent);
        }
        return this.radioBox;
    }

    public void setIndent(int indent) {
        this.indent = indent < 0 ? 0 : indent;
    }

    private void updateValue(String selectedValue) {
        this.value = selectedValue;
        if (this.radioButtons == null) {
            return;
        }
        if (this.value != null) {
            boolean found = false;
            Button[] buttonArray = this.radioButtons;
            int n = this.radioButtons.length;
            int n2 = 0;
            while (n2 < n) {
                Button radio = buttonArray[n2];
                boolean selection = false;
                if (((String)radio.getData()).equals(this.value)) {
                    selection = true;
                    found = true;
                }
                radio.setSelection(selection);
                ++n2;
            }
            if (found) {
                return;
            }
        }
        if (this.radioButtons.length > 0) {
            this.radioButtons[0].setSelection(true);
            this.value = (String)this.radioButtons[0].getData();
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        if (!this.useGroup) {
            super.setEnabled(enabled, parent);
        }
        Button[] buttonArray = this.radioButtons;
        int n = this.radioButtons.length;
        int n2 = 0;
        while (n2 < n) {
            Button radioButton = buttonArray[n2];
            radioButton.setEnabled(enabled);
            ++n2;
        }
    }

    protected Image getHelpIcon() {
        ImageDescriptor findImageDescriptor = SiriusEditPlugin.Implementation.findImageDescriptor(ICONS_PREFERENCES_HELP);
        return SiriusEditPlugin.getPlugin().getImage(findImageDescriptor);
    }
}

