/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.migrator.tasks;

import org.apache.tools.ant.BuildException;
import org.eclipse.emf.cdo.internal.migrator.CDOMigratorUtil;
import org.eclipse.emf.cdo.internal.migrator.messages.Messages;
import org.eclipse.emf.cdo.internal.migrator.tasks.CDOTask;
import org.eclipse.emf.codegen.ecore.genmodel.GenDelegationKind;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;

public class MigrateModelTask
extends CDOTask {
    private String modelPath;
    private boolean dynamicFeatureDelegation;

    public void setModelPath(String modelPath) {
        this.modelPath = modelPath;
    }

    public void setDynamicFeatureDelegation(boolean dynamicFeatureDelegation) {
        this.dynamicFeatureDelegation = dynamicFeatureDelegation;
    }

    @Override
    protected void checkAttributes() throws BuildException {
        MigrateModelTask.assertTrue("'modelPath' must be specified.", this.modelPath != null && this.modelPath.length() != 0);
    }

    @Override
    protected void doExecute() throws Exception {
        GenDelegationKind featureDelegation;
        GenModel genModel = CDOMigratorUtil.getGenModel(this.modelPath);
        String msg = CDOMigratorUtil.adjustGenModel(genModel, featureDelegation = this.dynamicFeatureDelegation ? GenDelegationKind.DYNAMIC_LITERAL : GenDelegationKind.REFLECTIVE_LITERAL);
        if (msg == null) {
            this.verbose(Messages.getString("MigrateAction_3"));
        } else {
            genModel.eResource().save(null);
            this.verbose(Messages.getString("MigrateAction_4") + msg);
        }
    }
}

