/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.codetemplates.ui.editor.embedded;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorActions;

public class CodetemplatesEmbeddedEditorActions
extends EmbeddedEditorActions {
    public CodetemplatesEmbeddedEditorActions(ISourceViewer viewer, IWorkbench workbench) {
        super(viewer, workbench);
    }

    protected void createFocusAndDisposeListeners() {
        final ArrayList handlerActivations = Lists.newArrayListWithExpectedSize((int)3);
        final IHandlerService handlerService = (IHandlerService)this.workbench.getAdapter(IHandlerService.class);
        final IContextService contextService = (IContextService)this.workbench.getAdapter(IContextService.class);
        Shell shell = this.viewer.getTextWidget().getShell();
        final ActiveShellExpression expression = new ActiveShellExpression(shell);
        final AtomicReference contextActivationHolder = new AtomicReference();
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                handlerService.deactivateHandlers((Collection)handlerActivations);
            }
        });
        this.viewer.getTextWidget().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                IContextActivation contextActivation = (IContextActivation)contextActivationHolder.get();
                if (contextActivation != null) {
                    contextService.deactivateContext(contextActivation);
                }
                handlerService.deactivateHandlers((Collection)handlerActivations);
                handlerActivations.clear();
            }

            public void focusGained(FocusEvent e) {
                IContextActivation contextActivation = contextService.activateContext("org.eclipse.xtext.ui.embeddedTextEditorScope", (Expression)expression);
                contextActivationHolder.set(contextActivation);
                for (IAction action : CodetemplatesEmbeddedEditorActions.this.allActions.values()) {
                    handlerActivations.add(handlerService.activateHandler(action.getActionDefinitionId(), (IHandler)new ActionHandler(action), (Expression)expression, true));
                }
            }
        });
    }

    public static class Factory
    extends EmbeddedEditorActions.Factory {
        @Inject(optional=true)
        protected IWorkbench workbench;

        protected EmbeddedEditorActions createActions(ISourceViewer viewer) {
            return new CodetemplatesEmbeddedEditorActions(viewer, this.workbench);
        }
    }
}

