/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.reviews.internal.server;

import org.eclipse.emf.cdo.lm.reviews.internal.server.ReviewManager;
import org.eclipse.emf.cdo.lm.reviews.internal.server.bundle.OM;
import org.eclipse.emf.cdo.lm.reviews.server.IReviewManager;
import org.eclipse.emf.cdo.lm.server.AbstractLifecycleManager;
import org.eclipse.emf.cdo.lm.server.LMAppExtension;
import org.eclipse.emf.cdo.lm.server.XMLLifecycleManager;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.spi.server.AppExtension;
import org.eclipse.emf.cdo.spi.server.IAppExtension4;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.Tree;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ReviewsAppExtension
extends AppExtension
implements IAppExtension4 {
    public static final int PRIORITY = 1100;
    private static final String DEFAULT_REVIEW_MANAGER_TYPE = OMPlatform.INSTANCE.getProperty("org.eclipse.emf.cdo.lm.reviews.internal.server.ReviewsAppExtension.DEFAULT_REVIEW_MANAGER_TYPE", "default");

    public String getName() {
        return "Reviews";
    }

    public int getPriority() {
        return 1100;
    }

    protected void start(InternalRepository repository, Element repositoryConfig) throws Exception {
        NodeList rmElements = repositoryConfig.getElementsByTagName("reviewManager");
        int length = rmElements.getLength();
        if (length > 1) {
            throw new IllegalStateException("At most one review manager must be configured for repository " + repository.getName());
        }
        if (length == 1) {
            Element rmElement = (Element)rmElements.item(0);
            this.configureReviewManager(repository, rmElement);
        }
    }

    protected void stop(InternalRepository repository) throws Exception {
        IReviewManager reviewManager = ReviewManager.ReviewManagerRegistry.INSTANCE.removeReviewManager(repository);
        if (reviewManager != null) {
            OM.LOG.info("Deactivating review manager of repository " + repository.getName());
            LifecycleUtil.deactivate((Object)reviewManager);
        }
    }

    private void configureReviewManager(InternalRepository repository, Element rmElement) {
        XMLLifecycleManager lifecycleManager = LMAppExtension.getLifecycleManager((IRepository)repository);
        if (lifecycleManager == null) {
            throw new IllegalStateException("A lifecycle manager must exist for the review manager of repository " + repository.getName());
        }
        ReviewManager reviewManager = this.createReviewManager(repository, rmElement);
        reviewManager.setLifecycleManager((AbstractLifecycleManager)lifecycleManager);
        OM.LOG.info("Activating review manager of repository " + repository.getName());
        reviewManager.activate();
        ReviewManager.ReviewManagerRegistry.INSTANCE.addReviewManager(repository, reviewManager);
    }

    protected String getDefaultReviewManagerType() {
        return DEFAULT_REVIEW_MANAGER_TYPE;
    }

    protected ReviewManager createReviewManager(InternalRepository repository, Element rmElement) {
        IManagedContainer container = repository.getContainer();
        String reviewManagerType = this.getDefaultReviewManagerType();
        return (ReviewManager)this.getContainerElement(rmElement, reviewManagerType, container);
    }

    private <T> T getContainerElement(Element element, String defaultType, IManagedContainer container) {
        String type = this.getAttribute(element, "type");
        if (StringUtil.isEmpty((String)type)) {
            type = defaultType;
        }
        Tree config = Tree.XMLConverter.convertElementToTree((Element)element);
        Object containerElement = container.createElement("org.eclipse.emf.cdo.lm.reviews.server.reviewManagers", type, config);
        return (T)containerElement;
    }
}

