/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.bnd;

import aQute.bnd.service.progress.ProgressPlugin;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class JobProgress
implements ProgressPlugin {
    public ProgressPlugin.Task startTask(String name, int size) {
        TaskJob taskjob = new TaskJob(name, size);
        taskjob.schedule();
        return taskjob;
    }

    private static class TaskJob
    extends Job
    implements ProgressPlugin.Task {
        private final String name;
        private final int size;
        private final AtomicReference<IStatus> status = new AtomicReference();
        private volatile IProgressMonitor monitor;

        TaskJob(String name, int size) {
            super(name);
            this.name = name;
            this.size = size;
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.monitor = monitor;
            monitor.beginTask(this.name, this.size);
            while (this.status.get() == null) {
                if (this.isCanceled(monitor)) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    monitor.setCanceled(true);
                    this.status.compareAndSet(null, Status.CANCEL_STATUS);
                    Thread.currentThread().interrupt();
                }
            }
            monitor.done();
            return this.status.get();
        }

        private boolean isCanceled(IProgressMonitor m) {
            boolean canceled = m.isCanceled();
            if (canceled) {
                this.status.compareAndSet(null, Status.CANCEL_STATUS);
            }
            return canceled;
        }

        public void worked(int units) {
            IProgressMonitor m = this.monitor;
            if (m == null || this.status.get() != null) {
                return;
            }
            m.worked(units);
        }

        public void done(String message, Throwable error) {
            if (error == null) {
                this.status.compareAndSet(null, Status.OK_STATUS);
            } else {
                this.status.compareAndSet(null, Status.error((String)message, (Throwable)error));
            }
        }

        public boolean isCanceled() {
            IProgressMonitor m = this.monitor;
            if (m == null) {
                return false;
            }
            return this.isCanceled(m);
        }
    }
}

