/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.view;

import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewRegistry;
import org.eclipse.emf.internal.cdo.util.AbstractRegistry;

public class CDOViewRegistryImpl
extends AbstractRegistry<CDOView, CDOViewRegistry.Registration>
implements CDOViewRegistry {
    public static final CDOViewRegistryImpl INSTANCE = new CDOViewRegistryImpl();

    @Override
    public CDOView[] getViews() {
        return (CDOView[])this.getRegisteredElements();
    }

    @Override
    public CDOView getView(int id) {
        return (CDOView)this.getElement(id);
    }

    protected CDOView[] newArray(int size) {
        return new CDOView[size];
    }

    protected CDOViewRegistry.Registration[] newRegistrationArray(int size) {
        return new CDOViewRegistry.Registration[size];
    }

    @Override
    protected CDOViewRegistry.Registration newRegistration(int id, CDOView view) {
        return new RegistrationImpl(id, view);
    }

    @Override
    protected int getRegisteredID(CDOViewRegistry.Registration registration) {
        return registration.getID();
    }

    @Override
    protected CDOView getRegisteredElement(CDOViewRegistry.Registration registration) {
        return registration.getView();
    }

    void register(CDOView view) {
        this.registerElement(view);
    }

    void deregister(CDOView view) {
        this.deregisterElement(view);
    }

    private static final class RegistrationImpl
    implements CDOViewRegistry.Registration {
        private final int id;
        private final CDOView view;

        public RegistrationImpl(int id, CDOView view) {
            this.id = id;
            this.view = view;
        }

        @Override
        public int getID() {
            return this.id;
        }

        @Override
        public CDOView getView() {
            return this.view;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ViewRegistration[id=");
            builder.append(this.id);
            builder.append(", session=");
            builder.append(this.view.getSession());
            builder.append(", view=");
            builder.append(this.view);
            builder.append("]");
            return builder.toString();
        }
    }
}

