/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.eresource.impl;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.cdo.common.util.CDODuplicateResourceException;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.common.util.CDOResourceNodeNotFoundException;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.internal.cdo.CDOObjectImpl;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.concurrent.CriticalSection;
import org.eclipse.net4j.util.om.OMPlatform;

public abstract class CDOResourceNodeImpl
extends CDOObjectImpl
implements CDOResourceNode {
    private static final boolean disableNameChecks = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.CDOResourceNode.disableNameChecks");
    private static final boolean singleExtensions = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.CDOResourceNode.singleExtensions");
    private static final ExtensionFinder EXTENSION_FINDER = singleExtensions ? new ExtensionFinder.Single() : new ExtensionFinder.Multi();

    protected CDOResourceNodeImpl() {
    }

    protected EClass eStaticClass() {
        return EresourcePackage.Literals.CDO_RESOURCE_NODE;
    }

    protected int eStaticFeatureCount() {
        return 0;
    }

    @Override
    public CDOResourceFolder getFolder() {
        return (CDOResourceFolder)this.eGet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_NODE__FOLDER, true);
    }

    public void setFolderGen(CDOResourceFolder newFolder) {
        this.eSet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_NODE__FOLDER, newFolder);
    }

    @Override
    public void setFolder(CDOResourceFolder newFolder) {
        this.basicSetFolder(newFolder, true);
    }

    public void basicSetFolder(CDOResourceFolder newFolder, boolean checkDuplicates) {
        CDOResourceFolder oldFolder = this.getFolder();
        if (!ObjectUtil.equals((Object)oldFolder, (Object)newFolder)) {
            String name;
            if (checkDuplicates && (name = this.getName()) != null) {
                String newPath = String.valueOf(newFolder == null ? "" : newFolder.getPath()) + CDOURIUtil.SEGMENT_SEPARATOR + name;
                this.checkDuplicates(newPath);
            }
            this.setFolderGen(newFolder);
        }
    }

    public void recacheURIs() {
    }

    @Override
    public String getName() {
        return (String)this.eGet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_NODE__NAME, true);
    }

    public void setNameGen(String newName) {
        this.eSet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_NODE__NAME, newName);
    }

    @Override
    public void setName(String newName) {
        this.basicSetName(newName, true);
    }

    public void basicSetName(String newName, boolean checkDuplicates) {
        String oldName;
        if (!disableNameChecks) {
            CheckUtil.checkArg((Object)newName, (String)"Name is null");
            CheckUtil.checkArg((newName.length() != 0 ? 1 : 0) != 0, (String)"Name is empty");
            CheckUtil.checkArg((!".".equals(newName) ? 1 : 0) != 0, (String)"Name is a dot");
            CheckUtil.checkArg((newName.indexOf(47) == -1 ? 1 : 0) != 0, (String)"Name contains a path separator");
        }
        if (!ObjectUtil.equals((Object)(oldName = this.getName()), (Object)newName)) {
            CDOResourceFolder parent;
            if (checkDuplicates && (parent = this.getFolder()) != null) {
                String newPath = String.valueOf(parent.getPath()) + CDOURIUtil.SEGMENT_SEPARATOR + newName;
                this.checkDuplicates(newPath);
            }
            this.setNameGen(newName);
        }
    }

    @Override
    public String getPath() {
        if (this.isRoot()) {
            return "/";
        }
        CDOResourceFolder folder = this.getFolder();
        if (folder == null) {
            return "/" + this.getName();
        }
        return String.valueOf(folder.getPath()) + "/" + this.getName();
    }

    @Override
    public void setPath(String newPath) {
        InternalCDOTransaction transaction = this.cdoView().toTransaction();
        if (newPath == null) {
            throw new CDOException(Messages.getString("CDOResourceNodeImpl.3"));
        }
        String oldPath = this.getPath();
        if (!ObjectUtil.equals((Object)oldPath, (Object)newPath)) {
            this.checkDuplicates(newPath);
            List<String> names = CDOURIUtil.analyzePath(newPath);
            if (names.isEmpty()) {
                throw new CDOException(Messages.getString("CDOResourceNodeImpl.4"));
            }
            String newName = names.remove(names.size() - 1);
            CDOResourceFolder newFolder = transaction.getOrCreateResourceFolder(names);
            if (newFolder == null) {
                transaction.getRootResource().getContents().add((Object)this);
            }
            this.basicSetFolder(newFolder, false);
            this.basicSetName(newName, false);
        }
    }

    @Override
    public String getExtension() {
        int dot;
        String name = this.getName();
        if (name != null && (dot = EXTENSION_FINDER.findExtension(name)) != -1) {
            return name.substring(dot + 1);
        }
        return "";
    }

    @Override
    public void setExtension(String extension) {
        this.sync().run(() -> this.setExtensionUnsynced(extension));
    }

    private void setExtensionUnsynced(String extension) {
        if (StringUtil.isEmpty((String)extension)) {
            this.setName(this.getBasename());
        } else {
            if (singleExtensions) {
                CheckUtil.checkArg((extension.indexOf(46) == -1 ? 1 : 0) != 0, (String)"Extension contains a dot");
            }
            this.setName(String.valueOf(this.getBasename()) + '.' + extension);
        }
    }

    @Override
    public String trimExtension() {
        return this.getBasename();
    }

    @Override
    public String getBasename() {
        int dot;
        String name = this.getName();
        if (name != null && (dot = EXTENSION_FINDER.findExtension(name)) != -1) {
            return name.substring(0, dot);
        }
        return name;
    }

    @Override
    public void setBasename(String basename) {
        this.sync().run(() -> this.setBasenameUnsynced(basename));
    }

    private void setBasenameUnsynced(String basename) {
        String extension;
        if (basename == null) {
            basename = "";
        }
        if (!singleExtensions) {
            CheckUtil.checkArg((basename.indexOf(46) == -1 ? 1 : 0) != 0, (String)"Basename contains a dot");
        }
        if (StringUtil.isEmpty((String)(extension = this.getExtension()))) {
            this.setName(basename);
        } else {
            this.setName(String.valueOf(basename) + '.' + extension);
        }
    }

    @Override
    public URI getURI() {
        String path;
        InternalCDOView view = this.cdoView();
        URI uri = CDOURIUtil.createResourceURI(view, path = this.getPath());
        if (uri != null) {
            URIConverter uriConverter = view.getResourceSet().getURIConverter();
            uri = uriConverter.normalize(uri);
        }
        return uri;
    }

    protected void checkDuplicates(String newPath) throws CDODuplicateResourceException {
        InternalCDOView view = this.cdoView();
        if (view != null) {
            view.clearResourcePathCacheIfNecessary(null);
            try {
                view.getResourceNodeID(newPath);
                throw new CDODuplicateResourceException(MessageFormat.format(Messages.getString("CDOResourceNodeImpl.5"), newPath));
            }
            catch (CDOResourceNodeNotFoundException cDOResourceNodeNotFoundException) {
                // empty catch block
            }
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getPath();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setPath((String)newValue);
                break;
            }
            default: {
                super.eSet(featureID, newValue);
            }
        }
        if (featureID == 1) {
            this.recacheURIs();
        }
    }

    @Override
    public String toString() {
        String string = super.toString();
        return this.toString(string);
    }

    protected String toString(String string) {
        InternalCDORevision revision = this.cdoRevision();
        if (revision != null) {
            String name = revision.getResourceNodeName();
            if (name == null) {
                name = "/";
            }
            string = String.valueOf(string) + "(\"" + name + "\")";
        }
        return string;
    }

    private CriticalSection sync() {
        InternalCDOView view = this.cdoView();
        if (view == null) {
            return CriticalSection.UNSYNCHRONIZED;
        }
        return view.sync();
    }

    private static interface ExtensionFinder {
        public static final char DOT = '.';

        public int findExtension(String var1);

        public static final class Multi
        implements ExtensionFinder {
            @Override
            public int findExtension(String name) {
                return name.indexOf(46);
            }
        }

        public static final class Single
        implements ExtensionFinder {
            @Override
            public int findExtension(String name) {
                return name.lastIndexOf(46);
            }
        }
    }
}

