/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.server;

import java.io.File;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.spi.server.AbstractAppExtension;
import org.eclipse.emf.cdo.spi.server.IAppExtension3;
import org.eclipse.emf.cdo.spi.server.IAppExtension5;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.RepositoryConfigurator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AppExtension
extends AbstractAppExtension
implements IAppExtension3,
IAppExtension5 {
    @Override
    public abstract String getName();

    @Override
    public boolean startBeforeRepositories() {
        return false;
    }

    @Override
    public final void start(File configFile) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void stop() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void start(IRepository[] repositories, File configFile) throws Exception {
        Document document = this.getDocument(configFile);
        RepositoryConfigurator.forEachChildElement(document.getDocumentElement(), "repository", repositoryConfig -> {
            String repositoryName = this.getAttribute(repositoryConfig, "name");
            InternalRepository repository = this.getRepository(repositories, repositoryName);
            if (repository != null) {
                try {
                    this.start(repository, repositoryConfig);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
        });
    }

    @Override
    public void stop(IRepository[] repositories) throws Exception {
        IRepository[] iRepositoryArray = repositories;
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            IRepository repository = iRepositoryArray[n2];
            try {
                this.stop((InternalRepository)repository);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
            ++n2;
        }
    }

    protected abstract void start(InternalRepository var1, Element var2) throws Exception;

    protected abstract void stop(InternalRepository var1) throws Exception;
}

