/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.util.CDOFingerPrinter;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.server.IQueryContext;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.spi.server.QueryHandlerFactory;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.ProductCreationException;

public class FingerPrintQueryHandler
implements IQueryHandler {
    private static final String DEFAULT_TYPE = "digest";
    private static final String DEFAULT_PARAM = "SHA-512,base64";

    @Override
    public void executeQuery(CDOQueryInfo info, IQueryContext context) {
        CDOID rootID;
        String param;
        IView view = context.getView();
        String type = (String)info.getParameter("type");
        if (StringUtil.isEmpty((String)type)) {
            type = DEFAULT_TYPE;
        }
        if (StringUtil.isEmpty((String)(param = (String)info.getParameter("param")))) {
            param = DEFAULT_PARAM;
        }
        if (CDOIDUtil.isNull((CDOID)(rootID = (CDOID)info.getContext()))) {
            rootID = view.getSession().getRepository().getRootResourceID();
        }
        IManagedContainer container = ContainerUtil.getContainer((Object)view.getRepository());
        CDOFingerPrinter fingerPrinter = (CDOFingerPrinter)container.getElement("org.eclipse.emf.cdo.common.util.fingerPrinters", type, param);
        CDOFingerPrinter.FingerPrint fingerPrint = fingerPrinter.createFingerPrint((CDORevisionProvider)view, rootID);
        context.addResult(fingerPrint.getValue());
        context.addResult(fingerPrint.getCount());
        context.addResult(param);
    }

    public static class Factory
    extends QueryHandlerFactory {
        public Factory() {
            super("fingerPrint");
        }

        @Override
        public FingerPrintQueryHandler create(String description) throws ProductCreationException {
            return new FingerPrintQueryHandler();
        }
    }
}

