/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.breakpoints;

import com.sun.jdi.VMDisconnectedException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaBreakpointListener;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaPrimitiveValue;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.eval.IAstEvaluationEngine;
import org.eclipse.jdt.debug.eval.ICompiledExpression;
import org.eclipse.jdt.debug.eval.IEvaluationListener;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.breakpoints.JDIDebugBreakpointMessages;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaLineBreakpoint;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDINullValue;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;

public class ConditionalBreakpointHandler
implements IJavaBreakpointListener {
    private boolean fHasErrors = false;

    @Override
    public void addingBreakpoint(IJavaDebugTarget target, IJavaBreakpoint breakpoint) {
    }

    @Override
    public void breakpointHasCompilationErrors(IJavaLineBreakpoint breakpoint, Message[] errors) {
    }

    @Override
    public void breakpointHasRuntimeException(IJavaLineBreakpoint breakpoint, DebugException exception) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int breakpointHit(IJavaThread thread, IJavaBreakpoint breakpoint) {
        if (!(breakpoint instanceof IJavaLineBreakpoint)) return 1;
        JavaLineBreakpoint lineBreakpoint = (JavaLineBreakpoint)breakpoint;
        try {
            Object lock;
            IJavaDebugTarget target;
            IAstEvaluationEngine engine;
            String condition = lineBreakpoint.getCondition();
            if (condition == null) {
                return 1;
            }
            EvaluationListener listener = new EvaluationListener(lineBreakpoint);
            IJavaStackFrame frame = (IJavaStackFrame)thread.getTopStackFrame();
            IJavaProject project = lineBreakpoint.getJavaProject(frame);
            if (project == null) {
                IMarker marker = breakpoint.getMarker();
                if (marker == null) {
                    this.fireConditionHasErrors(lineBreakpoint, new Message[]{new Message(JDIDebugBreakpointMessages.JavaLineBreakpoint_Unable_to_compile_conditional_breakpoint___missing_Java_project_context__1, -1)});
                    return 1;
                }
                IResource res = marker.getResource();
                IProject curProject = res.getProject();
                if (curProject == null) {
                    this.fireConditionHasErrors(lineBreakpoint, new Message[]{new Message(JDIDebugBreakpointMessages.JavaLineBreakpoint_Unable_to_compile_conditional_breakpoint___missing_Java_project_context__1, -1)});
                    return 1;
                }
                project = JavaCore.create((IProject)curProject);
            }
            if ((engine = this.getEvaluationEngine(target = (IJavaDebugTarget)thread.getDebugTarget(), project)) == null) {
                return 1;
            }
            ICompiledExpression expression = lineBreakpoint.getExpression(thread);
            if (expression == null) {
                expression = engine.getCompiledExpression(condition, frame);
                lineBreakpoint.setExpression(thread, expression);
            }
            if (expression.hasErrors()) {
                this.fireConditionHasErrors(lineBreakpoint, this.getMessages(expression));
                return 1;
            }
            Object object = lock = listener.getLock();
            synchronized (object) {
                engine.evaluateExpression(expression, frame, listener, 128, false);
                try {
                    lock.wait();
                }
                catch (InterruptedException e) {
                    this.fireConditionHasRuntimeErrors(lineBreakpoint, new DebugException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), JDIDebugBreakpointMessages.ConditionalBreakpointHandler_0, (Throwable)e)));
                    return 1;
                }
                return listener.getVote();
            }
        }
        catch (CoreException e) {
            DebugException de = null;
            de = e instanceof DebugException ? (DebugException)((Object)e) : new DebugException(e.getStatus());
            this.fireConditionHasRuntimeErrors(lineBreakpoint, de);
        }
        return 1;
    }

    @Override
    public void breakpointInstalled(IJavaDebugTarget target, IJavaBreakpoint breakpoint) {
    }

    @Override
    public void breakpointRemoved(IJavaDebugTarget target, IJavaBreakpoint breakpoint) {
    }

    @Override
    public int installingBreakpoint(IJavaDebugTarget target, IJavaBreakpoint breakpoint, IJavaType type) {
        return 0;
    }

    private IAstEvaluationEngine getEvaluationEngine(IJavaDebugTarget vm, IJavaProject project) {
        return ((JDIDebugTarget)vm).getEvaluationEngine(project);
    }

    private void fireConditionHasRuntimeErrors(IJavaLineBreakpoint breakpoint, DebugException exception) {
        this.fHasErrors = true;
        JDIDebugPlugin.getDefault().fireBreakpointHasRuntimeException(breakpoint, exception);
    }

    private void fireConditionHasErrors(IJavaLineBreakpoint breakpoint, Message[] messages) {
        this.fHasErrors = true;
        JDIDebugPlugin.getDefault().fireBreakpointHasCompilationErrors(breakpoint, messages);
    }

    private Message[] getMessages(ICompiledExpression expression) {
        String[] errorMessages = expression.getErrorMessages();
        Message[] messages = new Message[errorMessages.length];
        int i = 0;
        while (i < messages.length) {
            messages[i] = new Message(errorMessages[i], -1);
            ++i;
        }
        return messages;
    }

    public boolean hasErrors() {
        return this.fHasErrors;
    }

    class EvaluationListener
    implements IEvaluationListener {
        private final Object fLock = new Object();
        private final JavaLineBreakpoint fBreakpoint;
        private int fVote;

        EvaluationListener(JavaLineBreakpoint breakpoint) {
            this.fBreakpoint = breakpoint;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void evaluationComplete(IEvaluationResult result) {
            this.fVote = this.determineVote(result);
            Object object = this.fLock;
            synchronized (object) {
                this.fLock.notifyAll();
            }
        }

        private int determineVote(IEvaluationResult result) {
            IJavaValue value;
            JDIThread thread;
            block13: {
                block15: {
                    block14: {
                        if (result.isTerminated()) {
                            return 1;
                        }
                        thread = (JDIThread)result.getThread();
                        if (result.hasErrors()) {
                            DebugException exception = result.getException();
                            if (exception == null) {
                                return 2;
                            }
                            Throwable wrappedException = exception.getStatus().getException();
                            if (wrappedException instanceof VMDisconnectedException) {
                                return 2;
                            }
                            ConditionalBreakpointHandler.this.fireConditionHasRuntimeErrors(this.fBreakpoint, exception);
                            return 1;
                        }
                        try {
                            IJavaPrimitiveValue javaValue;
                            value = result.getValue();
                            if (!this.fBreakpoint.isConditionSuspendOnTrue()) break block13;
                            if (!(value instanceof IJavaPrimitiveValue) || !(javaValue = (IJavaPrimitiveValue)value).getJavaType().getName().equals("boolean")) break block14;
                            if (javaValue.getBooleanValue()) {
                                return 1;
                            }
                            return 2;
                        }
                        catch (DebugException e) {
                            JDIDebugPlugin.log(e);
                            return 1;
                        }
                    }
                    if (!(value instanceof JDIValue) || value instanceof JDINullValue) break block15;
                    JDIValue jdiValue = (JDIValue)value;
                    if (jdiValue.getJavaType().getName().equals("java.lang.Boolean")) {
                        IJavaPrimitiveValue javaValue = (IJavaPrimitiveValue)((IJavaObject)((Object)jdiValue)).getField("value", false).getValue();
                        if (javaValue.getBooleanValue()) {
                            return 1;
                        }
                        return 2;
                    }
                    return 2;
                }
                Status status = new Status(4, JDIDebugPlugin.getUniqueIdentifier(), MessageFormat.format(JDIDebugBreakpointMessages.ConditionalBreakpointHandler_1, value.getReferenceTypeName()));
                ConditionalBreakpointHandler.this.fireConditionHasRuntimeErrors(this.fBreakpoint, new DebugException((IStatus)status));
                return 1;
            }
            IDebugTarget debugTarget = thread.getDebugTarget();
            IValue lastValue = this.fBreakpoint.setCurrentConditionValue(debugTarget, value);
            if (!value.equals(lastValue)) {
                return 1;
            }
            return 2;
        }

        int getVote() {
            return this.fVote;
        }

        Object getLock() {
            return this.fLock;
        }
    }
}

