/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.command;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SetConnectionBendpointsAndLabelCommmand;
import org.eclipse.sirius.diagram.ui.tools.internal.util.GMFNotationUtilities;
import org.eclipse.sirius.ext.base.Option;

public class TreeLayoutSetConnectionBendpointsCommand
extends SetConnectionBendpointsAndLabelCommmand {
    public TreeLayoutSetConnectionBendpointsCommand(TransactionalEditingDomain editingDomain) {
        super(editingDomain);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        Assert.isNotNull((Object)this.getNewPointList());
        Assert.isNotNull((Object)this.getSourceRefPoint());
        Assert.isNotNull((Object)this.getTargetRefPoint());
        Edge edge = (Edge)this.getEdgeAdaptor().getAdapter(Edge.class);
        Assert.isNotNull((Object)edge);
        if (edge.getBendpoints() instanceof RelativeBendpoints) {
            RelativeBendpoints relativeBendpoints = (RelativeBendpoints)edge.getBendpoints();
            if (relativeBendpoints.getPoints().size() == 4) {
                Option<PrecisionPoint> optionalSourceRefPoint;
                Point oldLocationForEndOfSourceSegment = new Point(((RelativeBendpoint)relativeBendpoints.getPoints().get(1)).getSourceX(), ((RelativeBendpoint)relativeBendpoints.getPoints().get(1)).getSourceY());
                Point oldLocationForStartOfTargetSegment = new Point(((RelativeBendpoint)relativeBendpoints.getPoints().get(2)).getSourceX(), ((RelativeBendpoint)relativeBendpoints.getPoints().get(2)).getSourceY());
                ArrayList<RelativeBendpoint> newBendpoints = new ArrayList<RelativeBendpoint>();
                int numOfPoints = this.getNewPointList().size();
                int i = 0;
                while (i < numOfPoints) {
                    Dimension s = this.getNewPointList().getPoint(i).getDifference(this.getSourceRefPoint());
                    Dimension t = this.getNewPointList().getPoint(i).getDifference(this.getTargetRefPoint());
                    newBendpoints.add(new RelativeBendpoint(s.width, s.height, t.width, t.height));
                    i = (short)(i + 1);
                }
                ((RelativeBendpoint)newBendpoints.get(1)).getSourceY();
                int cfr_ignored_0 = oldLocationForEndOfSourceSegment.y;
                int deltaXTarget = oldLocationForStartOfTargetSegment.x - ((RelativeBendpoint)newBendpoints.get(2)).getSourceX();
                int deltaXSource = oldLocationForEndOfSourceSegment.x - ((RelativeBendpoint)newBendpoints.get(1)).getSourceX();
                Point targetRefPoint = this.getTargetRefPoint();
                Point sourceRefPoint = this.getSourceRefPoint();
                if (deltaXTarget != 0) {
                    Option<PrecisionPoint> optionalTargetRefPoint = GMFNotationUtilities.setTargetAnchor(edge, deltaXTarget);
                    if (optionalTargetRefPoint.some()) {
                        targetRefPoint = (Point)optionalTargetRefPoint.get();
                    }
                } else if (deltaXSource != 0 && (optionalSourceRefPoint = GMFNotationUtilities.setSourceAnchor(edge, deltaXTarget)).some()) {
                    sourceRefPoint = (Point)optionalSourceRefPoint.get();
                }
                GMFNotationUtilities.setGMFBendpoints(edge, this.getNewPointList(), sourceRefPoint, targetRefPoint);
                GMFNotationUtilities.setBrothersAnchorAndBendpointsAccordingToEdge(edge);
            } else {
                Point sourceRefPoint = this.getSourceRefPoint();
                Point targetRefPoint = this.getTargetRefPoint();
                Option<Point> optionalSourceRefPoint = GMFNotationUtilities.setSourceAnchor(edge, this.getNewPointList());
                Option<Point> optionalTargetRefPoint = GMFNotationUtilities.setTargetAnchor(edge, this.getNewPointList());
                if (optionalSourceRefPoint.some()) {
                    sourceRefPoint = (Point)optionalSourceRefPoint.get();
                }
                if (optionalTargetRefPoint.some()) {
                    targetRefPoint = (Point)optionalTargetRefPoint.get();
                }
                GMFNotationUtilities.setGMFBendpoints(edge, this.getNewPointList(), sourceRefPoint, targetRefPoint);
                GMFNotationUtilities.setBrothersAnchorAndBendpointsAccordingToEdge(edge);
            }
        }
        return CommandResult.newOKCommandResult();
    }
}

