/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.asciidoc.internal.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.asciidoc.internal.AsciiDocContentState;
import org.eclipse.mylyn.wikitext.parser.markup.Block;

public class AttributeDefinitionBlock
extends Block {
    private static final Pattern pattern = Pattern.compile("^:(.*?):(.*)");
    private String key;
    private String value;

    public boolean canStart(String line, int lineOffset) {
        Matcher matcher;
        if (lineOffset == 0 && (matcher = pattern.matcher(line)).matches()) {
            this.key = matcher.group(1);
            this.value = matcher.group(2);
            return true;
        }
        this.key = null;
        this.value = null;
        return false;
    }

    public int processLineContent(String line, int offset) {
        if (this.key.endsWith("!")) {
            this.key = this.key.substring(0, this.key.length() - 1).trim();
            ((AsciiDocContentState)this.getState()).removeAttribute(this.key);
        } else {
            String newKey = this.key.trim();
            String newValue = this.value == null ? "" : this.value.trim();
            ((AsciiDocContentState)this.getState()).putAttribute(newKey, newValue);
        }
        this.setClosed(true);
        return -1;
    }
}

