/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jenkins.core.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class JenkinsUrl {
    private static final String ENCODING = "UTF-8";
    String base;
    int depth = 1;
    List<String> exclude;
    String include;
    String key;
    List<String> values;
    String tree;

    public static JenkinsUrl create(String base) {
        JenkinsUrl url = new JenkinsUrl();
        url.base = base;
        return url;
    }

    private JenkinsUrl() {
    }

    public JenkinsUrl depth(int depth) {
        this.depth = depth;
        return this;
    }

    public JenkinsUrl exclude(String exclude) {
        if (this.exclude == null) {
            this.exclude = new ArrayList<String>();
        }
        this.exclude.add(exclude);
        return this;
    }

    public JenkinsUrl include(String include) {
        this.include = include;
        return this;
    }

    public JenkinsUrl match(String key, List<String> values) {
        this.key = key;
        this.values = values;
        return this;
    }

    public JenkinsUrl tree(String tree) {
        this.tree = tree;
        return this;
    }

    public String toUrl() throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder(this.base);
        if (!this.base.endsWith("/")) {
            sb.append("/");
        }
        sb.append("api/xml?wrapper=hudson&depth=");
        sb.append(this.depth);
        if (this.include != null) {
            sb.append("&xpath=");
            sb.append(this.include);
            if (this.key != null && this.values != null) {
                sb.append(this.getFilter());
            }
        }
        if (this.exclude != null) {
            for (String value : this.exclude) {
                sb.append("&exclude=");
                sb.append(value);
            }
        }
        if (this.tree != null) {
            sb.append("&tree=");
            sb.append(URLEncoder.encode(this.tree, ENCODING));
        }
        return sb.toString();
    }

    protected String getFilter() throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean appendSeparator = false;
        for (String value : this.values) {
            if (appendSeparator) {
                sb.append(" or ");
            } else {
                appendSeparator = true;
            }
            sb.append(this.key);
            sb.append("=");
            this.quote(sb, value);
        }
        sb.append("]");
        return URLEncoder.encode(sb.toString(), ENCODING);
    }

    private void quote(StringBuilder sb, String value) {
        char quote = '\'';
        if (value.contains("'")) {
            if (value.contains("\"")) {
                throw new IllegalArgumentException("Cannot query for a job which contains both a single and double quote in its name");
            }
            quote = '\"';
        }
        sb.append(quote);
        sb.append(value);
        sb.append(quote);
    }
}

