/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.OneIfRatherThanDuplicateBlocksThatFallThroughFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;

public class OneIfRatherThanDuplicateBlocksThatFallThroughCleanUpCore
extends AbstractCleanUp {
    public OneIfRatherThanDuplicateBlocksThatFallThroughCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public OneIfRatherThanDuplicateBlocksThatFallThroughCleanUpCore() {
    }

    @Override
    public CleanUpRequirements getRequirements() {
        return new CleanUpRequirements(this.requireAST(), false, false, null);
    }

    public boolean requireAST() {
        return this.isEnabled("cleanup.one_if_rather_than_duplicate_blocks_that_fall_through");
    }

    @Override
    public ICleanUpFix createFix(CleanUpContext context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null || !this.isEnabled("cleanup.one_if_rather_than_duplicate_blocks_that_fall_through")) {
            return null;
        }
        return OneIfRatherThanDuplicateBlocksThatFallThroughFixCore.createCleanUp(compilationUnit);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.one_if_rather_than_duplicate_blocks_that_fall_through")) {
            return new String[]{MultiFixMessages.OneIfRatherThanDuplicateBlocksThatFallThroughCleanUp_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        StringBuilder bld = new StringBuilder();
        if (this.isEnabled("cleanup.one_if_rather_than_duplicate_blocks_that_fall_through")) {
            bld.append("if (isActive || isValid) {\n");
        } else {
            bld.append("if (isActive) {\n");
        }
        bld.append("    System.out.println(\"The same code\");\n");
        bld.append("    throw new NullPointerException();\n");
        bld.append("}\n");
        if (!this.isEnabled("cleanup.one_if_rather_than_duplicate_blocks_that_fall_through")) {
            bld.append("if (isValid) {\n");
            bld.append("    System.out.println(\"The same code\");\n");
            bld.append("    throw new NullPointerException();\n");
            bld.append("}\n");
        }
        bld.append("System.out.println(\"Next code\");\n");
        if (this.isEnabled("cleanup.one_if_rather_than_duplicate_blocks_that_fall_through")) {
            bld.append("\n\n\n\n");
        }
        return bld.toString();
    }
}

