/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.profiling.ui;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.profiling.ui.BooleanWithGetSet;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class MessageDialogSyncedRunnable
extends MessageDialog {
    protected MessageDialogSyncedRunnable(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
    }

    public static boolean openQuestionSyncedRunnable(String title, String message) {
        return MessageDialogSyncedRunnable.openInSyncedRunnable(DialogueType.QUESTION, title, message);
    }

    public static boolean openConfirmSyncedRunnable(String title, String message) {
        return MessageDialogSyncedRunnable.openInSyncedRunnable(DialogueType.CONFIRMATION, title, message);
    }

    public static void openInformationSyncedRunnable(String title, String message) {
        MessageDialogSyncedRunnable.openInSyncedRunnable(DialogueType.INFO, title, message);
    }

    public static void openErrorSyncedRunnable(String title, String message) {
        MessageDialogSyncedRunnable.openInSyncedRunnable(DialogueType.ERROR, title, message);
    }

    private static boolean openInSyncedRunnable(DialogueType type, String title, String message) {
        BooleanWithGetSet userChoiceBool = new BooleanWithGetSet(false);
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            Shell parent = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            switch (type.ordinal()) {
                case 0: {
                    MessageDialog.openInformation((Shell)parent, (String)title, (String)message);
                    break;
                }
                case 1: {
                    MessageDialog.openError((Shell)parent, (String)title, (String)message);
                    break;
                }
                case 2: {
                    boolean okPressed = MessageDialog.openConfirm((Shell)parent, (String)title, (String)message);
                    userChoiceBool.setVal(okPressed);
                    break;
                }
                case 3: {
                    boolean okPressedQ = MessageDialog.openQuestion((Shell)parent, (String)title, (String)message);
                    userChoiceBool.setVal(okPressedQ);
                    break;
                }
            }
        });
        return userChoiceBool.getVal();
    }

    private static enum DialogueType {
        INFO,
        ERROR,
        CONFIRMATION,
        QUESTION;

    }
}

