/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PageLayout
extends Layout {
    private Point minimumPageSize = new Point(200, 200);

    public void layout(Composite composite, boolean force) {
        Rectangle rect = composite.getClientArea();
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].setSize(rect.width, rect.height);
            ++i;
        }
    }

    public Point computeSize(Composite composite, int wHint, int hHint, boolean force) {
        if (wHint != -1 && hHint != -1) {
            return new Point(wHint, hHint);
        }
        int x = this.minimumPageSize.x;
        int y = this.minimumPageSize.y;
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            Point size = children[i].computeSize(-1, -1, force);
            x = Math.max(x, size.x);
            y = Math.max(y, size.y);
            ++i;
        }
        if (wHint != -1) {
            x = wHint;
        }
        if (hHint != -1) {
            y = hHint;
        }
        return new Point(x, y);
    }
}

