/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.supports;

import org.eclipse.tm4e.languageconfiguration.internal.model.IndentationRules;

public class IndentRulesSupport {
    private final IndentationRules _indentationRules;

    public IndentRulesSupport(IndentationRules indentationRules) {
        this._indentationRules = indentationRules;
    }

    public boolean shouldIncrease(String text) {
        return this._indentationRules.increaseIndentPattern.matchesPartially(text);
    }

    public boolean shouldDecrease(String text) {
        return this._indentationRules.decreaseIndentPattern.matchesPartially(text);
    }

    public boolean shouldIndentNextLine(String text) {
        return this._indentationRules.indentNextLinePattern != null && this._indentationRules.indentNextLinePattern.matchesPartially(text);
    }

    public boolean shouldIgnore(String text) {
        return this._indentationRules.unIndentedLinePattern != null && this._indentationRules.unIndentedLinePattern.matchesPartially(text);
    }

    public int getIndentMetadata(String text) {
        int ret = 0;
        if (this.shouldIncrease(text)) {
            ++ret;
        }
        if (this.shouldDecrease(text)) {
            ret += 2;
        }
        if (this.shouldIndentNextLine(text)) {
            ret += 4;
        }
        if (this.shouldIgnore(text)) {
            ret += 8;
        }
        return ret;
    }

    public static final class IndentConsts {
        public static final int INCREASE_MASK = 1;
        public static final int DECREASE_MASK = 2;
        public static final int INDENT_NEXTLINE_MASK = 4;
        public static final int UNINDENT_MASK = 8;

        private IndentConsts() {
        }
    }
}

