/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.groups;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.groups.RepositoryGroup;
import org.eclipse.jgit.util.StringUtils;
import org.osgi.service.prefs.BackingStoreException;

public enum RepositoryGroups {
    INSTANCE;

    private static final String PREFS_GROUP_NAME_PREFIX = "RepositoryGroups.";
    private static final String PREFS_GROUPS = "RepositoryGroups.uuids";
    private static final String PREFS_GROUP_PREFIX = "RepositoryGroups.group.";
    private static final String EMPTY_STRING = "";
    private static final String SEPARATOR = "\n";
    private final Map<UUID, RepositoryGroup> groupMap = new HashMap<UUID, RepositoryGroup>();
    private final IEclipsePreferences preferences = RepositoryUtil.INSTANCE.getPreferences();

    private RepositoryGroups() {
        List<String> groups = this.split(this.preferences.get(PREFS_GROUPS, EMPTY_STRING));
        ArrayList<RepositoryGroup> toDelete = new ArrayList<RepositoryGroup>();
        for (String groupIdString : groups) {
            UUID groupId = UUID.fromString(groupIdString);
            String name = this.preferences.get(PREFS_GROUP_NAME_PREFIX + groupIdString, EMPTY_STRING);
            if (RepositoryGroups.isGroupNameInvalid(name)) {
                toDelete.add(new RepositoryGroup(groupId, name));
                Activator.logWarning(MessageFormat.format(UIText.RepositoryGroups_LoadPreferencesInvalidName, name), null);
                continue;
            }
            List<File> repos = this.split(this.preferences.get(PREFS_GROUP_PREFIX + groupIdString, EMPTY_STRING)).stream().map(arg_0 -> ((RepositoryUtil)RepositoryUtil.INSTANCE).getAbsoluteRepositoryPath(arg_0)).map(File::new).filter(File::isDirectory).collect(Collectors.toList());
            RepositoryGroup group = new RepositoryGroup(groupId, name, repos);
            this.groupMap.put(groupId, group);
        }
        if (!toDelete.isEmpty()) {
            this.delete(toDelete);
        }
    }

    private List<String> split(String input) {
        String[] split;
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = split = input.split(SEPARATOR);
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String trimmed;
            String string = stringArray[n2];
            if (string != null && (trimmed = string.trim()).length() > 0) {
                result.add(trimmed);
            }
            ++n2;
        }
        return result;
    }

    public boolean hasGroups() {
        return !this.groupMap.isEmpty();
    }

    public RepositoryGroup createGroup(String groupName) {
        RepositoryGroups.checkGroupName(groupName);
        if (!this.groupExists(groupName)) {
            UUID groupId = UUID.randomUUID();
            RepositoryGroup group = new RepositoryGroup(groupId, groupName);
            this.groupMap.put(groupId, group);
            this.savePreferences();
            return group;
        }
        throw new IllegalStateException(MessageFormat.format(UIText.RepositoryGroups_DuplicateGroupNameError, groupName));
    }

    public void renameGroup(RepositoryGroup group, String newName) {
        RepositoryGroups.checkGroupName(newName);
        RepositoryGroup myGroup = this.groupMap.get(group.getGroupId());
        if (myGroup != null && !newName.equals(myGroup.getName())) {
            myGroup.setGroupName(newName);
            this.savePreferences();
        }
    }

    public boolean groupExists(String groupName) {
        return this.groupMap.values().stream().anyMatch(group -> group.getName().equals(groupName));
    }

    private static boolean isGroupNameInvalid(String groupName) {
        return StringUtils.isEmptyOrNull((String)groupName) || !groupName.equals(groupName.trim()) || Utils.isMultiLine((String)groupName);
    }

    private static void checkGroupName(String groupName) {
        if (RepositoryGroups.isGroupNameInvalid(groupName)) {
            throw new IllegalArgumentException(UIText.RepositoryGroups_InvalidNameError);
        }
    }

    public void addRepositoriesToGroup(RepositoryGroup group, Collection<File> repoDirs) {
        if (!this.groupMap.containsKey(group.getGroupId())) {
            throw new IllegalArgumentException();
        }
        Collection<RepositoryGroup> currentGroups = this.groupMap.values();
        for (RepositoryGroup groups : currentGroups) {
            groups.removeRepositoryDirectories(repoDirs);
        }
        group.addRepositoryDirectories(repoDirs);
        this.savePreferences();
    }

    public void delete(Collection<RepositoryGroup> groupsToDelete) {
        for (RepositoryGroup group : groupsToDelete) {
            this.preferences.remove(PREFS_GROUP_PREFIX + String.valueOf(group.getGroupId()));
            this.preferences.remove(PREFS_GROUP_NAME_PREFIX + String.valueOf(group.getGroupId()));
            this.groupMap.remove(group.getGroupId());
        }
        this.savePreferences();
    }

    private void savePreferences() {
        try {
            ArrayList<String> groupIds = new ArrayList<String>();
            for (RepositoryGroup group : this.groupMap.values()) {
                String groupId = group.getGroupId().toString();
                groupIds.add(groupId);
                String name = group.getName();
                this.preferences.put(PREFS_GROUP_NAME_PREFIX + groupId, name);
                String repos = group.getRepositoryDirectories().stream().map(File::toString).map(arg_0 -> ((RepositoryUtil)RepositoryUtil.INSTANCE).relativizeToWorkspace(arg_0)).collect(Collectors.joining(SEPARATOR));
                this.preferences.put(PREFS_GROUP_PREFIX + groupId, repos);
            }
            this.preferences.put(PREFS_GROUPS, StringUtils.join(groupIds, (String)SEPARATOR));
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            Activator.logError(UIText.RepositoryGroups_SavePreferencesError, e);
        }
    }

    public List<RepositoryGroup> getGroups() {
        return new ArrayList<RepositoryGroup>(this.groupMap.values());
    }

    public boolean belongsToGroup(File repositoryDirectory) {
        return this.groupMap.values().stream().anyMatch(group -> group.getRepositoryDirectories().contains(repositoryDirectory));
    }

    public void removeFromGroups(List<File> repositoryDirectories) {
        for (RepositoryGroup group : this.groupMap.values()) {
            group.removeRepositoryDirectories(repositoryDirectories);
        }
        this.savePreferences();
    }
}

