/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import java.util.Arrays;
import java.util.Stack;
import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTReferenceOperator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.SemanticQueries;

public class AssignmentOperatorChecker
extends AbstractIndexAstChecker {
    public static final String MISS_REF_ID = "org.eclipse.cdt.codan.internal.checkers.MissReferenceProblem";
    public static final String MISS_SELF_CHECK_ID = "org.eclipse.cdt.codan.internal.checkers.MissSelfCheckProblem";
    private static final String OPERATOR_EQ = "operator =";

    public void processAst(IASTTranslationUnit ast) {
        ast.accept((ASTVisitor)new OnEachClass());
    }

    class OnEachClass
    extends ASTVisitor {
        private final Stack<OperatorEqInfo> opInfo = new Stack();

        OnEachClass() {
            this.shouldVisitDeclarations = true;
            this.shouldVisitExpressions = true;
        }

        public int visit(IASTDeclaration declaration) {
            ICPPMethod method = this.getOperatorEq(declaration);
            if (method != null) {
                OperatorEqInfo info = this.opInfo.push(new OperatorEqInfo());
                IASTFunctionDeclarator declMethod = ((ICPPASTFunctionDefinition)declaration).getDeclarator();
                if (!(declMethod instanceof ICPPASTFunctionDeclarator)) {
                    return 3;
                }
                if (((ICPPASTFunctionDefinition)declaration).isDefaulted() || ((ICPPASTFunctionDefinition)declaration).isDeleted()) {
                    return 3;
                }
                IASTPointerOperator[] pointers = declMethod.getPointerOperators();
                info.parameters = ((ICPPASTFunctionDeclarator)declMethod).getParameters();
                if (pointers.length != 1 || !(pointers[0] instanceof ICPPASTReferenceOperator)) {
                    AssignmentOperatorChecker.this.reportProblem(AssignmentOperatorChecker.MISS_REF_ID, (IASTNode)declaration, new Object[0]);
                }
                if (!SemanticQueries.isCopyOrMoveAssignmentOperator((ICPPMethod)method)) {
                    return 3;
                }
                info.decl = declMethod;
            }
            return 3;
        }

        public int leave(IASTDeclaration declaration) {
            if (this.getOperatorEq(declaration) != null && !this.opInfo.isEmpty()) {
                this.opInfo.pop();
            }
            return 3;
        }

        public int visit(IASTExpression expression) {
            if (!this.opInfo.isEmpty()) {
                OperatorEqInfo info = this.opInfo.peek();
                if (info.decl == null) {
                    return 3;
                }
                if (expression instanceof IASTBinaryExpression) {
                    IASTBinaryExpression binary = (IASTBinaryExpression)expression;
                    if (binary.getOperator() == 28 || binary.getOperator() == 29) {
                        if (this.referencesThis((IASTNode)binary.getOperand1()) && this.referencesParameter(info, (IASTNode)binary.getOperand2())) {
                            info.decl = null;
                        } else if (this.referencesThis((IASTNode)binary.getOperand2()) && this.referencesParameter(info, (IASTNode)binary.getOperand1())) {
                            info.decl = null;
                        } else {
                            AssignmentOperatorChecker.this.reportProblem(AssignmentOperatorChecker.MISS_SELF_CHECK_ID, (IASTNode)info.decl, new Object[0]);
                        }
                    } else {
                        AssignmentOperatorChecker.this.reportProblem(AssignmentOperatorChecker.MISS_SELF_CHECK_ID, (IASTNode)info.decl, new Object[0]);
                    }
                    info.decl = null;
                } else if (expression.getPropertyInParent() != ICPPASTFunctionDeclarator.NOEXCEPT_EXPRESSION) {
                    AssignmentOperatorChecker.this.reportProblem(AssignmentOperatorChecker.MISS_SELF_CHECK_ID, (IASTNode)info.decl, new Object[0]);
                    info.decl = null;
                }
            }
            return 3;
        }

        public boolean referencesParameter(OperatorEqInfo info, IASTNode expr) {
            if (expr instanceof IASTIdExpression) {
                IASTIdExpression id = (IASTIdExpression)expr;
                if (Arrays.equals(id.getName().getSimpleID(), info.parameters[0].getDeclarator().getName().getSimpleID())) {
                    return true;
                }
            } else if (expr instanceof ICPPASTUnaryExpression) {
                ICPPASTUnaryExpression unExpr = (ICPPASTUnaryExpression)expr;
                switch (unExpr.getOperator()) {
                    case 4: 
                    case 5: 
                    case 11: {
                        return this.referencesParameter(info, (IASTNode)unExpr.getOperand());
                    }
                }
            }
            return false;
        }

        public boolean referencesThis(IASTNode expr) {
            if (expr instanceof IASTLiteralExpression) {
                IASTLiteralExpression litArg = (IASTLiteralExpression)expr;
                if (litArg.getKind() == 4) {
                    return true;
                }
            } else if (expr instanceof ICPPASTUnaryExpression) {
                ICPPASTUnaryExpression unExpr = (ICPPASTUnaryExpression)expr;
                switch (unExpr.getOperator()) {
                    case 4: 
                    case 5: 
                    case 11: {
                        return this.referencesThis((IASTNode)unExpr.getOperand());
                    }
                }
            }
            return false;
        }

        private ICPPMethod getOperatorEq(IASTDeclaration decl) {
            if (decl instanceof ICPPASTFunctionDefinition) {
                ICPPMethod method;
                ICPPASTFunctionDefinition functionDefinition = (ICPPASTFunctionDefinition)decl;
                if (functionDefinition.isDeleted()) {
                    return null;
                }
                IBinding binding = functionDefinition.getDeclarator().getName().resolveBinding();
                if (binding instanceof ICPPMethod && AssignmentOperatorChecker.OPERATOR_EQ.equals((method = (ICPPMethod)binding).getName())) {
                    return method;
                }
            }
            return null;
        }
    }

    private static class OperatorEqInfo {
        IASTDeclarator decl;
        ICPPASTParameterDeclaration[] parameters;

        private OperatorEqInfo() {
        }
    }
}

