/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.IRefreshEvent;
import org.eclipse.team.internal.ui.synchronize.IRefreshSubscriberListener;
import org.eclipse.team.internal.ui.synchronize.WorkbenchAction;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ParticipantPageDialog;
import org.eclipse.team.ui.synchronize.ParticipantPageSaveablePart;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;
import org.eclipse.ui.actions.ActionFactory;

public class RefreshUserNotificationPolicyInModalDialog
implements IRefreshSubscriberListener {
    private final SubscriberParticipant participant;
    private final ISynchronizePageConfiguration configuration;
    private final Shell shell;
    private final String title;

    public RefreshUserNotificationPolicyInModalDialog(Shell shell, String title, ISynchronizePageConfiguration configuration, SubscriberParticipant participant) {
        this.title = title;
        this.configuration = configuration;
        this.participant = participant;
        this.shell = shell;
    }

    @Override
    public void refreshStarted(IRefreshEvent event) {
    }

    @Override
    public ActionFactory.IWorkbenchAction refreshDone(final IRefreshEvent event) {
        if (event.getParticipant() != this.participant) {
            return null;
        }
        int severity = event.getStatus().getSeverity();
        if (severity == 8 || severity == 4) {
            return null;
        }
        return new WorkbenchAction(){

            public void run() {
                if (event.getStatus().getCode() == 0) {
                    MessageDialog.openInformation((Shell)RefreshUserNotificationPolicyInModalDialog.this.shell, (String)TeamUIMessages.OpenComparedDialog_noChangeTitle, (String)TeamUIMessages.OpenComparedDialog_noChangesMessage);
                    return;
                }
                RefreshUserNotificationPolicyInModalDialog.this.compareAndOpenDialog(event, RefreshUserNotificationPolicyInModalDialog.this.participant);
                this.setEnabled(false);
            }

            @Override
            public void dispose() {
                if (TeamUI.getSynchronizeManager().get(RefreshUserNotificationPolicyInModalDialog.this.participant.getId(), RefreshUserNotificationPolicyInModalDialog.this.participant.getSecondaryId()) == null) {
                    RefreshUserNotificationPolicyInModalDialog.this.participant.dispose();
                }
            }
        };
    }

    protected void compareAndOpenDialog(IRefreshEvent event, SubscriberParticipant participant) {
        CompareConfiguration cc = new CompareConfiguration();
        ParticipantPageSaveablePart input = new ParticipantPageSaveablePart(Utils.getShell(null), cc, this.configuration, participant){

            @Override
            public String getTitle() {
                return RefreshUserNotificationPolicyInModalDialog.this.title;
            }
        };
        try {
            ParticipantPageDialog dialog = new ParticipantPageDialog(this.shell, input, participant);
            dialog.setBlockOnOpen(true);
            dialog.open();
        }
        finally {
            input.dispose();
        }
    }
}

