/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.jdt.facade;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class JdtFacade {
    private static final MethodHandle INLINE_JSR_BYTECODE = JdtFacade.findInlineJsrBytecode();
    private static final MethodHandle ORIGINAL_SOURCE_LEVEL = JdtFacade.findOriginalSourceLevel();
    private static final MethodHandle ORIGINAL_COMPLIANCE_LEVEL = JdtFacade.findOriginalComplianceLevel();

    private static MethodHandle findInlineJsrBytecode() {
        try {
            return MethodHandles.lookup().findSetter(CompilerOptions.class, "inlineJsrBytecode", Boolean.TYPE);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static MethodHandle findOriginalSourceLevel() {
        try {
            return MethodHandles.lookup().findSetter(CompilerOptions.class, "originalSourceLevel", Long.TYPE);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static MethodHandle findOriginalComplianceLevel() {
        try {
            return MethodHandles.lookup().findSetter(CompilerOptions.class, "originalComplianceLevel", Long.TYPE);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setInlineJsrBytecode(CompilerOptions compilerOptions, boolean inlineJsrBytecode) {
        if (INLINE_JSR_BYTECODE != null) {
            try {
                INLINE_JSR_BYTECODE.invoke(compilerOptions, true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void setOriginalSourceLevel(CompilerOptions compilerOptions, long targetLevel) {
        if (ORIGINAL_SOURCE_LEVEL != null) {
            try {
                ORIGINAL_SOURCE_LEVEL.invoke(compilerOptions, targetLevel);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void setOriginalComplianceLevel(CompilerOptions compilerOptions, long targetLevel) {
        if (ORIGINAL_COMPLIANCE_LEVEL != null) {
            try {
                ORIGINAL_COMPLIANCE_LEVEL.invoke(compilerOptions, targetLevel);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

