/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.time.Duration;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.AssertionFailureBuilder;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.function.ThrowingSupplier;
import org.junit.jupiter.api.util.PreemptiveTimeoutUtils;
import org.opentest4j.AssertionFailedError;

class AssertTimeoutPreemptively {
    static void assertTimeoutPreemptively(Duration timeout, Executable executable) {
        AssertTimeoutPreemptively.assertTimeoutPreemptively(timeout, executable, (String)null);
    }

    static void assertTimeoutPreemptively(Duration timeout, Executable executable, @Nullable String message) {
        AssertTimeoutPreemptively.assertTimeoutPreemptively(timeout, () -> {
            executable.execute();
            return null;
        }, message);
    }

    static void assertTimeoutPreemptively(Duration timeout, Executable executable, Supplier<@Nullable String> messageSupplier) {
        AssertTimeoutPreemptively.assertTimeoutPreemptively(timeout, () -> {
            executable.execute();
            return null;
        }, messageSupplier);
    }

    static <T> T assertTimeoutPreemptively(Duration timeout, ThrowingSupplier<T> supplier) {
        return PreemptiveTimeoutUtils.executeWithPreemptiveTimeout(timeout, supplier, null, AssertTimeoutPreemptively::createAssertionFailure);
    }

    static <T> T assertTimeoutPreemptively(Duration timeout, ThrowingSupplier<T> supplier, @Nullable String message) {
        return PreemptiveTimeoutUtils.executeWithPreemptiveTimeout(timeout, supplier, message == null ? null : () -> message, AssertTimeoutPreemptively::createAssertionFailure);
    }

    static <T> T assertTimeoutPreemptively(Duration timeout, ThrowingSupplier<T> supplier, Supplier<@Nullable String> messageSupplier) {
        return PreemptiveTimeoutUtils.executeWithPreemptiveTimeout(timeout, supplier, messageSupplier, AssertTimeoutPreemptively::createAssertionFailure);
    }

    private static AssertionFailedError createAssertionFailure(Duration timeout, @Nullable Supplier<@Nullable String> messageSupplier, @Nullable Throwable cause, @Nullable Thread thread) {
        return AssertionFailureBuilder.assertionFailure().message(messageSupplier).reason("execution timed out after " + timeout.toMillis() + " ms").cause(cause).build();
    }

    private AssertTimeoutPreemptively() {
    }
}

