/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IProjectConfiguration;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.wizards.MavenPomWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnableNatureAction
implements IObjectActionDelegate,
IExecutableExtension {
    private static final Logger log = LoggerFactory.getLogger(EnableNatureAction.class);
    public static final String ID = "org.eclipse.m2e.enableNatureAction";
    static final String ID_WORKSPACE = "org.eclipse.m2e.enableWorkspaceResolutionAction";
    static final String ID_MODULES = "org.eclipse.m2e.enableModulesAction";
    private boolean workspaceProjects = true;
    private ISelection selection;

    public EnableNatureAction() {
    }

    public EnableNatureAction(String option) {
        this.setInitializationData(null, null, option);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        if ("noworkspace".equals(data)) {
            this.workspaceProjects = false;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        ISelection iSelection = this.selection;
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)iSelection;
            for (Object element : structuredSelection) {
                IProject project = null;
                if (element instanceof IProject) {
                    IProject p;
                    project = p = (IProject)element;
                } else if (element instanceof IAdaptable) {
                    IAdaptable adaptable = (IAdaptable)element;
                    project = (IProject)adaptable.getAdapter(IProject.class);
                }
                if (project == null) continue;
                this.enableNature(project, structuredSelection.size() == 1);
            }
        }
    }

    private void enableNature(final IProject project, boolean isSingle) {
        IFile pom = project.getFile("pom.xml");
        if (!pom.exists()) {
            if (isSingle) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                MavenPomWizard wizard = new MavenPomWizard();
                wizard.init(workbench, (IStructuredSelection)this.selection);
                Shell shell = workbench.getActiveWorkbenchWindow().getShell();
                WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard);
                wizardDialog.create();
                wizardDialog.getShell().setText(Messages.EnableNatureAction_wizard_shell);
                if (wizardDialog.open() == 1) {
                    return;
                }
            } else {
                log.warn(NLS.bind((String)"Skipping project {0}, no pom.xml file present, no reason to have maven nature enabled", (Object)project.getName()));
                return;
            }
        }
        Job job = new Job(Messages.EnableNatureAction_job_enable){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ResolverConfiguration configuration = new ResolverConfiguration(project);
                    configuration.setResolveWorkspaceProjects(EnableNatureAction.this.workspaceProjects);
                    configuration.setSelectedProfiles("");
                    boolean hasMavenNature = project.hasNature("org.eclipse.m2e.core.maven2Nature");
                    IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
                    configurationManager.enableMavenNature(project, (IProjectConfiguration)configuration, monitor);
                    if (!hasMavenNature) {
                        configurationManager.updateProjectConfiguration(project, monitor);
                    }
                }
                catch (CoreException ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

