/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.List;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.internal.monitor.ui.MonitorUiPlugin;
import org.eclipse.mylyn.internal.tasks.core.ITaskJobFactory;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.ui.SynchronizeRelevantTasksJob;
import org.eclipse.mylyn.internal.tasks.ui.TaskListSynchronizationScheduler;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.monitor.ui.IUserAttentionListener;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.sync.SynchronizationJob;

class TaskListScheduledSynchronizationManager {
    private static final int DELAY_QUERY_REFRESH_ON_STARTUP = 20000;
    private static final List<String> FULL_REFRESH_ENABLEMENT_KEYS = List.of("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule");
    private static final List<String> RELEVANT_TASKS_REFRESH_ENABLEMENT_KEYS = List.of("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule", "org.eclipse.mylyn.tasks.ui.relevant.tasks.synch.schedule");
    private final TaskListSynchronizationScheduler fullRefreshScheduler;
    private final TaskListSynchronizationScheduler relevantTaskScheduler;

    public TaskListScheduledSynchronizationManager(ITaskJobFactory taskJobFactory, TaskActivityManager taskActivityManager, IRepositoryManager repositoryManager) {
        SynchronizationJob refreshJob = taskJobFactory.createSynchronizeRepositoriesJob(null);
        refreshJob.setFullSynchronization(true);
        this.fullRefreshScheduler = new TaskListSynchronizationScheduler((Job)refreshJob);
        this.updateSynchronizationScheduler(this.fullRefreshScheduler, true, "org.eclipse.mylyn.tasks.ui.repositories.synch.schedule.miliseconds", FULL_REFRESH_ENABLEMENT_KEYS);
        SynchronizeRelevantTasksJob relevantJob = new SynchronizeRelevantTasksJob(taskActivityManager, repositoryManager, taskJobFactory);
        this.relevantTaskScheduler = new TaskListSynchronizationScheduler(relevantJob);
        this.updateSynchronizationScheduler(this.relevantTaskScheduler, true, "org.eclipse.mylyn.tasks.ui.relevant.tasks.synch.schedule.miliseconds", RELEVANT_TASKS_REFRESH_ENABLEMENT_KEYS);
        MonitorUiPlugin.getDefault().getActivityContextManager().addListener((IUserAttentionListener)this.fullRefreshScheduler);
        MonitorUiPlugin.getDefault().getActivityContextManager().addListener((IUserAttentionListener)this.relevantTaskScheduler);
    }

    public void processPreferenceChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule.miliseconds") || event.getProperty().equals("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule")) {
            this.updateSynchronizationScheduler(this.fullRefreshScheduler, false, "org.eclipse.mylyn.tasks.ui.repositories.synch.schedule.miliseconds", FULL_REFRESH_ENABLEMENT_KEYS);
        }
        if (event.getProperty().equals("org.eclipse.mylyn.tasks.ui.relevant.tasks.synch.schedule.miliseconds") || event.getProperty().equals("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule") || event.getProperty().equals("org.eclipse.mylyn.tasks.ui.relevant.tasks.synch.schedule")) {
            this.updateSynchronizationScheduler(this.relevantTaskScheduler, false, "org.eclipse.mylyn.tasks.ui.relevant.tasks.synch.schedule.miliseconds", RELEVANT_TASKS_REFRESH_ENABLEMENT_KEYS);
        }
    }

    private void updateSynchronizationScheduler(TaskListSynchronizationScheduler scheduler, boolean isInitialInvocation, String intervalKey, List<String> enabledKeys) {
        if (scheduler == null) {
            return;
        }
        boolean enabled = true;
        for (String enabledKey : enabledKeys) {
            enabled &= TasksUiPlugin.getDefault().getPreferenceStore().getBoolean(enabledKey);
        }
        if (enabled) {
            long interval = TasksUiPlugin.getDefault().getPreferenceStore().getLong(intervalKey);
            if (isInitialInvocation) {
                scheduler.setInterval(20000L, interval);
            } else {
                scheduler.setInterval(interval);
            }
        } else {
            scheduler.setInterval(0L);
        }
    }
}

