/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.labeling;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtend.core.jvmmodel.DispatchHelper;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtend.core.xtend.XtendAnnotationType;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendEnum;
import org.eclipse.xtend.core.xtend.XtendEnumLiteral;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendInterface;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.ide.labeling.XtendImages;
import org.eclipse.xtend.ide.labeling.XtendJvmLabelProvider;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedField;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.ui.labeling.XbaseImageAdornments;
import org.eclipse.xtext.xbase.validation.UIStrings;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;

public class XtendLabelProvider
extends XtendJvmLabelProvider {
    @Inject
    private UIStrings uiStrings;
    @Inject
    private XtendImages images;
    @Inject
    @Extension
    private IXtendJvmAssociations _iXtendJvmAssociations;
    @Inject
    private XbaseImageAdornments adornments;
    @Inject
    @Extension
    private DispatchHelper _dispatchHelper;
    @Inject
    private OperatorMapping operatorMapping;

    @Inject
    public XtendLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    protected ImageDescriptor _imageDescriptor(XtendFile element) {
        return this.images.forFile();
    }

    protected ImageDescriptor _imageDescriptor(XtendClass element) {
        return this.images.forClass(element.getVisibility(), this.adornments.get((JvmIdentifiableElement)this._iXtendJvmAssociations.getInferredType(element)));
    }

    protected ImageDescriptor _imageDescriptor(XtendInterface element) {
        return this.images.forInterface(element.getVisibility(), this.adornments.get((JvmIdentifiableElement)this._iXtendJvmAssociations.getInferredType(element)));
    }

    protected ImageDescriptor _imageDescriptor(XtendEnum element) {
        return this.images.forEnum(element.getVisibility(), this.adornments.get((JvmIdentifiableElement)this._iXtendJvmAssociations.getInferredType((XtendTypeDeclaration)element)));
    }

    protected ImageDescriptor _imageDescriptor(XtendAnnotationType element) {
        return this.images.forAnnotation(element.getVisibility(), this.adornments.get((JvmIdentifiableElement)this._iXtendJvmAssociations.getInferredType((XtendTypeDeclaration)element)));
    }

    protected ImageDescriptor _imageDescriptor(XtendFunction element) {
        ImageDescriptor _xblockexpression = null;
        JvmOperation operation = this._iXtendJvmAssociations.getDirectlyInferredOperation(element);
        ImageDescriptor _xifexpression = null;
        if (operation != null) {
            _xifexpression = this.images.forOperation(element.getVisibility(), this.adornments.get((JvmIdentifiableElement)operation));
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected ImageDescriptor _imageDescriptor(AnonymousClass element) {
        return this.images.forClass(this._iXtendJvmAssociations.getInferredType(element).getVisibility(), this.adornments.get((JvmIdentifiableElement)this._iXtendJvmAssociations.getInferredType(element)));
    }

    protected ImageDescriptor _imageDescriptor(JvmOperation operation) {
        ImageDescriptor _xifexpression = null;
        boolean _isDispatcherFunction = this._dispatchHelper.isDispatcherFunction(operation);
        _xifexpression = _isDispatcherFunction ? this.images.forDispatcherFunction(operation.getVisibility(), this.adornments.get((JvmIdentifiableElement)operation)) : this.images.forOperation(operation.getVisibility(), this.adornments.get((JvmIdentifiableElement)operation));
        return _xifexpression;
    }

    protected ImageDescriptor _imageDescriptor(XtendConstructor element) {
        return this.images.forConstructor(element.getVisibility(), this.adornments.get((JvmIdentifiableElement)this._iXtendJvmAssociations.getInferredConstructor(element)));
    }

    protected ImageDescriptor _imageDescriptor(XtendField element) {
        return this.images.forField(element.getVisibility(), this.adornments.get((JvmIdentifiableElement)this._iXtendJvmAssociations.getJvmField(element)));
    }

    protected ImageDescriptor _imageDescriptor(XtendEnumLiteral element) {
        return this.images.forField(element.getVisibility(), this.adornments.get((JvmIdentifiableElement)this._iXtendJvmAssociations.getJvmField(element)));
    }

    protected String text(XtendFile element) {
        return element.eResource().getURI().trimFileExtension().lastSegment();
    }

    protected String text(XtendClass element) {
        String _name = element.getName();
        String _xifexpression = null;
        boolean _isEmpty = element.getTypeParameters().isEmpty();
        _xifexpression = _isEmpty ? "" : this.uiStrings.typeParameters((Iterable)element.getTypeParameters());
        return _name + _xifexpression;
    }

    protected String text(XtendInterface element) {
        String _name = element.getName();
        String _xifexpression = null;
        boolean _isEmpty = element.getTypeParameters().isEmpty();
        _xifexpression = _isEmpty ? "" : this.uiStrings.typeParameters((Iterable)element.getTypeParameters());
        return _name + _xifexpression;
    }

    protected String text(AnonymousClass element) {
        return this.text(this._iXtendJvmAssociations.getInferredType(element));
    }

    protected String text(XtendConstructor element) {
        String _parameters = this.uiStrings.parameters((JvmIdentifiableElement)this._iXtendJvmAssociations.getInferredConstructor(element));
        return "new" + _parameters;
    }

    protected StyledString text(XtendFunction element) {
        QualifiedName qnName;
        QualifiedName operator;
        String simpleName = element.getName();
        if (simpleName != null && (operator = this.operatorMapping.getOperator(qnName = QualifiedName.create((String)simpleName))) != null) {
            StyledString result = this.signature(operator.getFirstSegment(), (JvmIdentifiableElement)this._iXtendJvmAssociations.getDirectlyInferredOperation(element));
            result.append(" (" + simpleName + ")", StyledString.COUNTER_STYLER);
            return result;
        }
        return this.signature(element.getName(), (JvmIdentifiableElement)this._iXtendJvmAssociations.getDirectlyInferredOperation(element));
    }

    protected StyledString text(XtendField element) {
        StyledString _xblockexpression = null;
        if (element.getName() == null && element.isExtension()) {
            String _referenceToString = this.uiStrings.referenceToString(element.getType(), "extension");
            return new StyledString(_referenceToString, StyledString.DECORATIONS_STYLER);
        }
        JvmTypeReference fieldType = this.getDisplayedType(element);
        if (fieldType != null) {
            boolean _notEquals;
            String type = this.uiStrings.referenceToString(fieldType, "");
            int _length = type.length();
            boolean bl = _notEquals = _length != 0;
            if (_notEquals) {
                String _name = element.getName();
                StyledString _styledString = new StyledString(_name);
                StyledString _styledString_1 = new StyledString(" : " + type, StyledString.DECORATIONS_STYLER);
                return _styledString.append(_styledString_1);
            }
        }
        String _name_1 = element.getName();
        _xblockexpression = new StyledString(_name_1);
        return _xblockexpression;
    }

    protected String text(XtendEnumLiteral element) {
        return element.getName();
    }

    protected String text(XtendParameter element) {
        String _simpleName = element.getParameterType().getSimpleName();
        String _plus = _simpleName + " ";
        String _name = element.getName();
        return _plus + _name;
    }

    protected JvmTypeReference getDisplayedType(XtendField field) {
        EObject next;
        Object _xblockexpression = null;
        JvmField jvmField = this._iXtendJvmAssociations.getJvmField(field);
        if (jvmField != null) {
            return jvmField.getType();
        }
        Iterator i = this._iXtendJvmAssociations.getJvmElements((EObject)field).iterator();
        boolean _hasNext = i.hasNext();
        if (_hasNext && (next = (EObject)i.next()) instanceof JvmOperation) {
            return ((JvmOperation)next).getReturnType();
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    @XbaseGenerated
    protected ImageDescriptor imageDescriptor(Object operation) {
        if (operation instanceof JvmConstructor) {
            return this._imageDescriptor((JvmConstructor)operation);
        }
        if (operation instanceof JvmOperation) {
            return this._imageDescriptor((JvmOperation)operation);
        }
        if (operation instanceof JvmAnnotationType) {
            return this._imageDescriptor((JvmAnnotationType)operation);
        }
        if (operation instanceof JvmEnumerationType) {
            return this._imageDescriptor((JvmEnumerationType)operation);
        }
        if (operation instanceof JvmField) {
            return this._imageDescriptor((JvmField)operation);
        }
        if (operation instanceof JvmGenericType) {
            return this._imageDescriptor((JvmGenericType)operation);
        }
        if (operation instanceof AnonymousClass) {
            return this._imageDescriptor((AnonymousClass)operation);
        }
        if (operation instanceof XtendAnnotationType) {
            return this._imageDescriptor((XtendAnnotationType)operation);
        }
        if (operation instanceof XtendClass) {
            return this._imageDescriptor((XtendClass)operation);
        }
        if (operation instanceof XtendConstructor) {
            return this._imageDescriptor((XtendConstructor)operation);
        }
        if (operation instanceof XtendEnum) {
            return this._imageDescriptor((XtendEnum)operation);
        }
        if (operation instanceof XtendFunction) {
            return this._imageDescriptor((XtendFunction)operation);
        }
        if (operation instanceof XtendInterface) {
            return this._imageDescriptor((XtendInterface)operation);
        }
        if (operation instanceof JvmTypeParameter) {
            return this._imageDescriptor((JvmTypeParameter)operation);
        }
        if (operation instanceof XtendEnumLiteral) {
            return this._imageDescriptor((XtendEnumLiteral)operation);
        }
        if (operation instanceof XtendField) {
            return this._imageDescriptor((XtendField)operation);
        }
        if (operation instanceof JvmFormalParameter) {
            return this._imageDescriptor((JvmFormalParameter)operation);
        }
        if (operation instanceof XVariableDeclaration) {
            return this._imageDescriptor((XVariableDeclaration)operation);
        }
        if (operation instanceof XtendFile) {
            return this._imageDescriptor((XtendFile)operation);
        }
        if (operation instanceof IResolvedConstructor) {
            return this._imageDescriptor((IResolvedConstructor)operation);
        }
        if (operation instanceof IResolvedOperation) {
            return this._imageDescriptor((IResolvedOperation)operation);
        }
        if (operation instanceof XImportDeclaration) {
            return this._imageDescriptor((XImportDeclaration)operation);
        }
        if (operation instanceof XImportSection) {
            return this._imageDescriptor((XImportSection)operation);
        }
        if (operation instanceof IResolvedField) {
            return this._imageDescriptor((IResolvedField)operation);
        }
        if (operation != null) {
            return this._imageDescriptor(operation);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(operation).toString());
    }
}

