/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.model;

import org.eclipse.tm4e.core.internal.utils.StringUtils;
import org.eclipse.tm4e.languageconfiguration.internal.utils.Indentation;

public class CursorConfiguration {
    public final boolean insertSpaces;
    public final int indentSize;

    public CursorConfiguration(boolean insertSpaces, int indentSize) {
        this.insertSpaces = insertSpaces;
        this.indentSize = Math.max(1, indentSize);
    }

    public String normalizeIndentation(String str) {
        return Indentation.normalizeIndentation(str, this.indentSize, this.insertSpaces);
    }

    public String outdentString(String str) {
        String indent;
        if (str.startsWith("\t")) {
            return str.substring(1);
        }
        if (this.insertSpaces && str.startsWith(indent = this.getIndent())) {
            return str.substring(indent.length());
        }
        return str;
    }

    public String getIndent() {
        return this.insertSpaces ? " ".repeat(this.indentSize) : "\t";
    }

    public String toString() {
        return StringUtils.toString((Object)this, sb -> {
            StringBuilder stringBuilder = sb.append("insertSpaces=").append(this.insertSpaces).append(", ").append("indentSize=").append(this.indentSize);
        });
    }
}

