/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.generator.trace;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.trace.AbsoluteURI;
import org.eclipse.xtext.generator.trace.internal.AbstractTraceForURIProvider;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.generator.trace.IEclipseTrace;
import org.eclipse.xtext.ui.generator.trace.ITraceForStorageProvider;
import org.eclipse.xtext.ui.generator.trace.StorageAwareTrace;
import org.eclipse.xtext.ui.generator.trace.TraceMarkers;
import org.eclipse.xtext.ui.generator.trace.WrappedCoreException;
import org.eclipse.xtext.ui.workspace.EclipseProjectConfigProvider;
import org.eclipse.xtext.workspace.IProjectConfig;

public class TraceForStorageProvider
extends AbstractTraceForURIProvider<IFile, StorageAwareTrace>
implements ITraceForStorageProvider {
    @Deprecated
    public static final String TRACE_FILE_EXTENSION = "._trace";
    private static final Logger LOG = Logger.getLogger(TraceForStorageProvider.class);
    @Inject
    private Provider<StorageAwareTrace> traceToSourceProvider;
    @Inject
    private TraceMarkers traceMarkers;
    @Inject
    private IWorkspace workspace;

    protected IFile asFile(AbsoluteURI absoluteURI, IProjectConfig project) {
        IFile result;
        URI uri = absoluteURI.getURI();
        if (uri.isPlatformResource() && (result = this.workspace.getRoot().getFile((IPath)new Path(uri.toPlatformString(true)))).exists()) {
            return result;
        }
        return null;
    }

    protected List<AbstractTraceForURIProvider.PersistedTrace> findInverseTraceFiles(IFile sourceFile) {
        List<IPath> traceFiles = this.findTraceMarkers(sourceFile);
        if (!traceFiles.isEmpty()) {
            ArrayList result = Lists.newArrayListWithCapacity((int)traceFiles.size());
            for (IPath path : traceFiles) {
                IFile file = this.workspace.getRoot().getFile(path);
                if (!file.exists()) {
                    return Collections.emptyList();
                }
                FileBasedTrace trace = new FileBasedTrace(file);
                result.add(trace);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private List<IPath> findTraceMarkers(IFile sourceFile) {
        try {
            return this.traceMarkers.findTraceFiles(sourceFile);
        }
        catch (CoreException e) {
            return Collections.emptyList();
        }
    }

    protected AbstractTraceForURIProvider.PersistedTrace findPersistedTrace(IFile generatedFile) {
        IFile traceFile = this.getTraceFile(generatedFile);
        if (traceFile.exists()) {
            return new FileBasedTrace(traceFile);
        }
        return null;
    }

    protected AbsoluteURI getAbsoluteLocation(IFile file) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        return new AbsoluteURI(uri);
    }

    protected IProjectConfig getProjectConfig(IFile sourceFile) {
        AbsoluteURI location = this.getAbsoluteLocation(sourceFile);
        IResourceServiceProvider resourceServiceProvider = this.getServiceProvider(location);
        if (resourceServiceProvider != null) {
            EclipseProjectConfigProvider projectConfigProvider = (EclipseProjectConfigProvider)resourceServiceProvider.get(EclipseProjectConfigProvider.class);
            return projectConfigProvider.createProjectConfig(sourceFile.getProject());
        }
        LOG.error((Object)("No trace available for source file " + String.valueOf(sourceFile.getFullPath()) + ", since no resource service provider could be determined."));
        return null;
    }

    protected StorageAwareTrace newAbstractTrace(IFile file) {
        StorageAwareTrace result = (StorageAwareTrace)this.traceToSourceProvider.get();
        result.setLocalStorage((IStorage)file);
        return result;
    }

    public IEclipseTrace getTraceToTarget(IStorage sourceResource) {
        if (sourceResource instanceof IFile) {
            IFile file = (IFile)sourceResource;
            return (IEclipseTrace)this.getTraceToTarget(file, this.getAbsoluteLocation(file), this.getProjectConfig(file));
        }
        return null;
    }

    public IEclipseTrace getTraceToSource(IStorage derivedResource) {
        if (derivedResource instanceof IFile) {
            return (IEclipseTrace)this.doGetTraceToSource((IFile)derivedResource);
        }
        return null;
    }

    @Override
    public IFile getTraceFile(IFile generatedFile) {
        String originLastSegment = generatedFile.getFullPath().lastSegment();
        IFile traceFile = generatedFile.getParent().getFile((IPath)new Path(this.getTraceFileNameProvider().getTraceFromJava(originLastSegment)));
        return traceFile;
    }

    @Override
    public boolean isTraceFile(IStorage storage) {
        if (!(storage instanceof IFile)) {
            return false;
        }
        IFile file = (IFile)storage;
        String originLastSegment = file.getFullPath().lastSegment();
        return this.getTraceFileNameProvider().isTraceFileName(originLastSegment);
    }

    protected class FileBasedTrace
    implements AbstractTraceForURIProvider.PersistedTrace {
        private final IFile file;

        protected FileBasedTrace(IFile file) {
            this.file = file;
        }

        public AbsoluteURI getPath() {
            return TraceForStorageProvider.this.getAbsoluteLocation(this.file);
        }

        public long getModificationStamp() {
            return this.file.getModificationStamp();
        }

        public InputStream openStream() throws IOException {
            try {
                return this.file.getContents();
            }
            catch (CoreException e) {
                throw new WrappedCoreException(e);
            }
        }

        public boolean exists() {
            return this.file.exists();
        }
    }
}

