/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.lifecyclemapping.model.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingFilter;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadata;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionFilter;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionMetadata;

public class LifecycleMappingMetadataSourceXpp3Reader {
    private boolean addDefaultEntities = true;
    public final ContentTransformer contentTransformer;

    public LifecycleMappingMetadataSourceXpp3Reader() {
        this(new ContentTransformer(){

            @Override
            public String transform(String source, String fieldName) {
                return source;
            }
        });
    }

    public LifecycleMappingMetadataSourceXpp3Reader(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    private boolean checkFieldWithDuplicate(XmlPullParser parser, String tagName, String alias, Set<String> parsed) throws XmlPullParserException {
        if (!parser.getName().equals(tagName) && !parser.getName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser, String attribute, String tagName, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getBooleanValue(s, attribute, parser, null);
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser, String defaultValue) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getDateValue(s, attribute, null, parser);
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
            }
        }
        return null;
    }

    private double getDoubleValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, (Throwable)nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, (Throwable)nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        if (s == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private String interpolatedTrimmed(String value, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value, context));
    }

    private int nextTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int eventType = parser.next();
        if (eventType == 4) {
            eventType = parser.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null);
        }
        return eventType;
    }

    public LifecycleMappingMetadataSource read(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        LifecycleMappingMetadataSource lifecycleMappingMetadataSource = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"lifecycleMappingMetadata".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'lifecycleMappingMetadata' but found '" + parser.getName() + "'", parser, null);
                }
                if (parsed) {
                    throw new XmlPullParserException("Duplicated tag: 'lifecycleMappingMetadata'", parser, null);
                }
                lifecycleMappingMetadataSource = this.parseLifecycleMappingMetadataSource(parser, strict);
                lifecycleMappingMetadataSource.setModelEncoding(parser.getInputEncoding());
                parsed = true;
            }
            eventType = parser.next();
        }
        if (parsed) {
            return lifecycleMappingMetadataSource;
        }
        throw new XmlPullParserException("Expected root element 'lifecycleMappingMetadata' but found no element at all: invalid XML document", parser, null);
    }

    public LifecycleMappingMetadataSource read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser.setInput(reader);
        return this.read((XmlPullParser)parser, strict);
    }

    public LifecycleMappingMetadataSource read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public LifecycleMappingMetadataSource read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.read((Reader)new XmlStreamReader(in), strict);
    }

    public LifecycleMappingMetadataSource read(InputStream in) throws IOException, XmlPullParserException {
        return this.read((Reader)new XmlStreamReader(in));
    }

    public LifecycleMappingFilter readLifecycleMappingFilter(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        LifecycleMappingFilter lifecycleMappingFilter = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"lifecycleMappingFilter".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'lifecycleMappingFilter' but found '" + parser.getName() + "'", parser, null);
                }
                if (parsed) {
                    throw new XmlPullParserException("Duplicated tag: 'lifecycleMappingFilter'", parser, null);
                }
                lifecycleMappingFilter = this.parseLifecycleMappingFilter(parser, strict);
                parsed = true;
            }
            eventType = parser.next();
        }
        if (parsed) {
            return lifecycleMappingFilter;
        }
        throw new XmlPullParserException("Expected root element 'lifecycleMappingFilter' but found no element at all: invalid XML document", parser, null);
    }

    public LifecycleMappingFilter readLifecycleMappingFilter(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser.setInput(reader);
        return this.readLifecycleMappingFilter((XmlPullParser)parser, strict);
    }

    public LifecycleMappingFilter readLifecycleMappingFilter(Reader reader) throws IOException, XmlPullParserException {
        return this.readLifecycleMappingFilter(reader, true);
    }

    public LifecycleMappingFilter readLifecycleMappingFilter(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.readLifecycleMappingFilter((Reader)new XmlStreamReader(in), strict);
    }

    public LifecycleMappingFilter readLifecycleMappingFilter(InputStream in) throws IOException, XmlPullParserException {
        return this.readLifecycleMappingFilter((Reader)new XmlStreamReader(in));
    }

    public LifecycleMappingMetadata readLifecycleMappingMetadata(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        LifecycleMappingMetadata lifecycleMappingMetadata = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"lifecycleMapping".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'lifecycleMapping' but found '" + parser.getName() + "'", parser, null);
                }
                if (parsed) {
                    throw new XmlPullParserException("Duplicated tag: 'lifecycleMapping'", parser, null);
                }
                lifecycleMappingMetadata = this.parseLifecycleMappingMetadata(parser, strict);
                parsed = true;
            }
            eventType = parser.next();
        }
        if (parsed) {
            return lifecycleMappingMetadata;
        }
        throw new XmlPullParserException("Expected root element 'lifecycleMapping' but found no element at all: invalid XML document", parser, null);
    }

    public LifecycleMappingMetadata readLifecycleMappingMetadata(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser.setInput(reader);
        return this.readLifecycleMappingMetadata((XmlPullParser)parser, strict);
    }

    public LifecycleMappingMetadata readLifecycleMappingMetadata(Reader reader) throws IOException, XmlPullParserException {
        return this.readLifecycleMappingMetadata(reader, true);
    }

    public LifecycleMappingMetadata readLifecycleMappingMetadata(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.readLifecycleMappingMetadata((Reader)new XmlStreamReader(in), strict);
    }

    public LifecycleMappingMetadata readLifecycleMappingMetadata(InputStream in) throws IOException, XmlPullParserException {
        return this.readLifecycleMappingMetadata((Reader)new XmlStreamReader(in));
    }

    public PluginExecutionFilter readPluginExecutionFilter(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        PluginExecutionFilter pluginExecutionFilter = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"pluginExecutionFilter".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'pluginExecutionFilter' but found '" + parser.getName() + "'", parser, null);
                }
                if (parsed) {
                    throw new XmlPullParserException("Duplicated tag: 'pluginExecutionFilter'", parser, null);
                }
                pluginExecutionFilter = this.parsePluginExecutionFilter(parser, strict);
                parsed = true;
            }
            eventType = parser.next();
        }
        if (parsed) {
            return pluginExecutionFilter;
        }
        throw new XmlPullParserException("Expected root element 'pluginExecutionFilter' but found no element at all: invalid XML document", parser, null);
    }

    public PluginExecutionFilter readPluginExecutionFilter(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser.setInput(reader);
        return this.readPluginExecutionFilter((XmlPullParser)parser, strict);
    }

    public PluginExecutionFilter readPluginExecutionFilter(Reader reader) throws IOException, XmlPullParserException {
        return this.readPluginExecutionFilter(reader, true);
    }

    public PluginExecutionFilter readPluginExecutionFilter(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.readPluginExecutionFilter((Reader)new XmlStreamReader(in), strict);
    }

    public PluginExecutionFilter readPluginExecutionFilter(InputStream in) throws IOException, XmlPullParserException {
        return this.readPluginExecutionFilter((Reader)new XmlStreamReader(in));
    }

    public PluginExecutionMetadata readPluginExecutionMetadata(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        PluginExecutionMetadata pluginExecutionMetadata = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"pluginExecution".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'pluginExecution' but found '" + parser.getName() + "'", parser, null);
                }
                if (parsed) {
                    throw new XmlPullParserException("Duplicated tag: 'pluginExecution'", parser, null);
                }
                pluginExecutionMetadata = this.parsePluginExecutionMetadata(parser, strict);
                parsed = true;
            }
            eventType = parser.next();
        }
        if (parsed) {
            return pluginExecutionMetadata;
        }
        throw new XmlPullParserException("Expected root element 'pluginExecution' but found no element at all: invalid XML document", parser, null);
    }

    public PluginExecutionMetadata readPluginExecutionMetadata(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser.setInput(reader);
        return this.readPluginExecutionMetadata((XmlPullParser)parser, strict);
    }

    public PluginExecutionMetadata readPluginExecutionMetadata(Reader reader) throws IOException, XmlPullParserException {
        return this.readPluginExecutionMetadata(reader, true);
    }

    public PluginExecutionMetadata readPluginExecutionMetadata(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.readPluginExecutionMetadata((Reader)new XmlStreamReader(in), strict);
    }

    public PluginExecutionMetadata readPluginExecutionMetadata(InputStream in) throws IOException, XmlPullParserException {
        return this.readPluginExecutionMetadata((Reader)new XmlStreamReader(in));
    }

    private LifecycleMappingFilter parseLifecycleMappingFilter(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        LifecycleMappingFilter lifecycleMappingFilter = new LifecycleMappingFilter();
        int i = parser.getAttributeCount() - 1;
        while (i >= 0) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) < 0) {
                this.checkUnknownAttribute(parser, name, tagName, strict);
            }
            --i;
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "symbolicName", null, parsed)) {
                lifecycleMappingFilter.setSymbolicName(this.interpolatedTrimmed(parser.nextText(), "symbolicName"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "versionRange", null, parsed)) {
                lifecycleMappingFilter.setVersionRange(this.interpolatedTrimmed(parser.nextText(), "versionRange"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "pluginExecutions", null, parsed)) {
                HashSet<PluginExecutionFilter> pluginExecutions = new HashSet<PluginExecutionFilter>();
                while (parser.nextTag() == 2) {
                    if ("pluginExecution".equals(parser.getName())) {
                        pluginExecutions.add(this.parsePluginExecutionFilter(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                lifecycleMappingFilter.setPluginExecutions(pluginExecutions);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "packagingTypes", null, parsed)) {
                HashSet<String> packagingTypes = new HashSet<String>();
                while (parser.nextTag() == 2) {
                    if ("packagingType".equals(parser.getName())) {
                        packagingTypes.add(this.interpolatedTrimmed(parser.nextText(), "packagingTypes"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                lifecycleMappingFilter.setPackagingTypes(packagingTypes);
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return lifecycleMappingFilter;
    }

    private LifecycleMappingMetadata parseLifecycleMappingMetadata(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        LifecycleMappingMetadata lifecycleMappingMetadata = new LifecycleMappingMetadata();
        int i = parser.getAttributeCount() - 1;
        while (i >= 0) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) < 0) {
                this.checkUnknownAttribute(parser, name, tagName, strict);
            }
            --i;
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "packagingType", null, parsed)) {
                lifecycleMappingMetadata.setPackagingType(this.interpolatedTrimmed(parser.nextText(), "packagingType"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "lifecycleMappingId", null, parsed)) {
                lifecycleMappingMetadata.setLifecycleMappingId(this.interpolatedTrimmed(parser.nextText(), "lifecycleMappingId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "lifecycleMappingVersionRange", null, parsed)) {
                lifecycleMappingMetadata.setLifecycleMappingVersionRange(this.interpolatedTrimmed(parser.nextText(), "lifecycleMappingVersionRange"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "pluginExecutions", null, parsed)) {
                ArrayList<PluginExecutionMetadata> pluginExecutions = new ArrayList<PluginExecutionMetadata>();
                while (parser.nextTag() == 2) {
                    if ("pluginExecution".equals(parser.getName())) {
                        pluginExecutions.add(this.parsePluginExecutionMetadata(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                lifecycleMappingMetadata.setPluginExecutions(pluginExecutions);
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return lifecycleMappingMetadata;
    }

    private LifecycleMappingMetadataSource parseLifecycleMappingMetadataSource(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        LifecycleMappingMetadataSource lifecycleMappingMetadataSource = new LifecycleMappingMetadataSource();
        int i = parser.getAttributeCount() - 1;
        while (i >= 0) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) < 0 && !"xmlns".equals(name)) {
                this.checkUnknownAttribute(parser, name, tagName, strict);
            }
            --i;
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "lifecycleMappings", null, parsed)) {
                ArrayList<LifecycleMappingMetadata> lifecycleMappings = new ArrayList<LifecycleMappingMetadata>();
                while (parser.nextTag() == 2) {
                    if ("lifecycleMapping".equals(parser.getName())) {
                        lifecycleMappings.add(this.parseLifecycleMappingMetadata(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                lifecycleMappingMetadataSource.setLifecycleMappings(lifecycleMappings);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "pluginExecutions", null, parsed)) {
                ArrayList<PluginExecutionMetadata> pluginExecutions = new ArrayList<PluginExecutionMetadata>();
                while (parser.nextTag() == 2) {
                    if ("pluginExecution".equals(parser.getName())) {
                        pluginExecutions.add(this.parsePluginExecutionMetadata(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                lifecycleMappingMetadataSource.setPluginExecutions(pluginExecutions);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "lifecycleMappingFilters", null, parsed)) {
                ArrayList<LifecycleMappingFilter> lifecycleMappingFilters = new ArrayList<LifecycleMappingFilter>();
                while (parser.nextTag() == 2) {
                    if ("lifecycleMappingFilter".equals(parser.getName())) {
                        lifecycleMappingFilters.add(this.parseLifecycleMappingFilter(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                lifecycleMappingMetadataSource.setLifecycleMappingFilters(lifecycleMappingFilters);
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return lifecycleMappingMetadataSource;
    }

    private PluginExecutionFilter parsePluginExecutionFilter(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String value;
        String tagName = parser.getName();
        PluginExecutionFilter pluginExecutionFilter = new PluginExecutionFilter();
        int i = parser.getAttributeCount() - 1;
        while (i >= 0) {
            String name = parser.getAttributeName(i);
            value = parser.getAttributeValue(i);
            if (name.indexOf(58) < 0) {
                this.checkUnknownAttribute(parser, name, tagName, strict);
            }
            --i;
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "groupId", null, parsed)) {
                pluginExecutionFilter.setGroupId(this.interpolatedTrimmed(parser.nextText(), "groupId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "artifactId", null, parsed)) {
                pluginExecutionFilter.setArtifactId(this.interpolatedTrimmed(parser.nextText(), "artifactId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "versionRange", null, parsed)) {
                pluginExecutionFilter.setVersionRange(this.interpolatedTrimmed(parser.nextText(), "versionRange"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "goals", null, parsed)) {
                HashSet<String> goals = new HashSet<String>();
                while (parser.nextTag() == 2) {
                    if ("goal".equals(parser.getName())) {
                        goals.add(this.interpolatedTrimmed(parser.nextText(), "goals"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                pluginExecutionFilter.setGoals(goals);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "parameters", null, parsed)) {
                while (parser.nextTag() == 2) {
                    String key = parser.getName();
                    value = parser.nextText().trim();
                    pluginExecutionFilter.addParameter(key, value);
                }
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return pluginExecutionFilter;
    }

    private PluginExecutionMetadata parsePluginExecutionMetadata(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        PluginExecutionMetadata pluginExecutionMetadata = new PluginExecutionMetadata();
        int i = parser.getAttributeCount() - 1;
        while (i >= 0) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) < 0) {
                this.checkUnknownAttribute(parser, name, tagName, strict);
            }
            --i;
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "pluginExecutionFilter", null, parsed)) {
                pluginExecutionMetadata.setFilter(this.parsePluginExecutionFilter(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "action", null, parsed)) {
                pluginExecutionMetadata.setActionDom(Xpp3DomBuilder.build((XmlPullParser)parser, (boolean)true));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "comment", null, parsed)) {
                pluginExecutionMetadata.setComment(this.interpolatedTrimmed(parser.nextText(), "comment"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return pluginExecutionMetadata;
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }
}

