/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.extension.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.settings.model.extension.CFileData;
import org.eclipse.cdt.core.settings.model.extension.CFolderData;
import org.eclipse.cdt.core.settings.model.extension.CResourceData;
import org.eclipse.cdt.core.settings.model.util.IPathSettingsContainerVisitor;
import org.eclipse.cdt.core.settings.model.util.PathSettingsContainer;
import org.eclipse.core.runtime.IPath;

public class CResourceDataContainer {
    private PathSettingsContainer fRcDataContainer;
    private boolean fIncludeCurrent;

    public CResourceDataContainer(PathSettingsContainer pathSettings, boolean includeCurrent) {
        this.fRcDataContainer = pathSettings;
        this.fIncludeCurrent = includeCurrent;
    }

    public void changeCurrentPath(IPath path, boolean moveChildren) {
        this.fRcDataContainer.setPath(path, moveChildren);
    }

    public IPath getCurrentPath() {
        return this.fRcDataContainer.getPath();
    }

    public CResourceData getCurrentResourceData() {
        return (CResourceData)this.fRcDataContainer.getValue();
    }

    public CResourceData getResourceData(IPath path, boolean exactPath) {
        PathSettingsContainer cr = this.fRcDataContainer.getChildContainer(path, false, exactPath);
        if (cr != null) {
            return (CResourceData)cr.getValue();
        }
        return null;
    }

    public CResourceData[] getResourceDatas() {
        return this.getResourceDatas(12);
    }

    public CResourceData[] getResourceDatas(int kind) {
        return this.getResourceDatas(kind, CResourceData.class);
    }

    public CResourceData[] getResourceDatas(int kind, Class<CResourceData> clazz) {
        List<CResourceData> list = this.getRcDataList(kind);
        CResourceData[] datas = (CResourceData[])Array.newInstance(clazz, list.size());
        return list.toArray(datas);
    }

    public List<CResourceData> getRcDataList(final int kind) {
        final ArrayList<CResourceData> list = new ArrayList<CResourceData>();
        this.fRcDataContainer.accept(new IPathSettingsContainerVisitor(){

            @Override
            public boolean visit(PathSettingsContainer container) {
                CResourceData data;
                if ((CResourceDataContainer.this.fIncludeCurrent || container != CResourceDataContainer.this.fRcDataContainer) && ((data = (CResourceData)container.getValue()).getType() & kind) == data.getType()) {
                    list.add(data);
                }
                return true;
            }
        });
        return list;
    }

    public CResourceData getResourceData(IPath path, boolean exactPath, int kind) {
        CResourceData data = this.getResourceData(path, exactPath);
        if (data != null && (data.getType() & kind) == data.getType()) {
            return data;
        }
        return null;
    }

    public void removeResourceData(IPath path) {
        this.fRcDataContainer.removeChildContainer(path);
    }

    public void addResourceData(CResourceData data) {
        PathSettingsContainer cr = this.fRcDataContainer.getChildContainer(data.getPath(), true, true);
        cr.setValue(data);
    }

    public CFileData getFileData(IPath path) {
        return (CFileData)this.getResourceData(path, true, 8);
    }

    public CFolderData getFolderData(IPath path) {
        return (CFolderData)this.getResourceData(path, true, 4);
    }
}

