/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.util;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.RepositoryTemplateManager;
import org.eclipse.mylyn.internal.tasks.core.util.ContributorBlackList;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.RepositoryTemplate;
import org.eclipse.osgi.util.NLS;

public class RepositoryTemplateExtensionReader {
    public static final String EXTENSION_TEMPLATES = "org.eclipse.mylyn.tasks.core.templates";
    public static final String EXTENSION_TMPL_REPOSITORY = "repository";
    public static final String ELMNT_TMPL_LABEL = "label";
    public static final String ELMNT_TMPL_URLREPOSITORY = "urlRepository";
    public static final String ELMNT_TMPL_REPOSITORYKIND = "repositoryKind";
    public static final String ELMNT_TMPL_CHARACTERENCODING = "characterEncoding";
    public static final String ELMNT_TMPL_ANONYMOUS = "anonymous";
    public static final String ELMNT_TMPL_VERSION = "version";
    public static final String ELMNT_TMPL_URLNEWTASK = "urlNewTask";
    public static final String ELMNT_TMPL_URLTASK = "urlTask";
    public static final String ELMNT_TMPL_URLTASKQUERY = "urlTaskQuery";
    public static final String ELMNT_TMPL_NEWACCOUNTURL = "urlNewAccount";
    public static final String ELMNT_TMPL_ADDAUTO = "addAutomatically";
    private final IRepositoryManager repositoryManager;
    private final RepositoryTemplateManager templateManager;

    public RepositoryTemplateExtensionReader(IRepositoryManager repositoryManager, RepositoryTemplateManager templateManager) {
        this.repositoryManager = repositoryManager;
        this.templateManager = templateManager;
    }

    public void loadExtensions(ContributorBlackList blackList) {
        IExtension[] templateExtensions;
        MultiStatus result = new MultiStatus("org.eclipse.mylyn.tasks.core", 0, "Unexpected error while loading repository template extensions", null);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint templatesExtensionPoint = registry.getExtensionPoint(EXTENSION_TEMPLATES);
        IExtension[] iExtensionArray = templateExtensions = templatesExtensionPoint.getExtensions();
        int n = templateExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension templateExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = templateExtension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IStatus status;
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (!blackList.isDisabled(element) && element.getName().equals(EXTENSION_TMPL_REPOSITORY) && !(status = this.readRepositoryTemplate(element)).isOK()) {
                    result.add(status);
                }
                ++n4;
            }
            ++n2;
        }
        if (!result.isOK()) {
            StatusHandler.log((IStatus)result);
        }
    }

    private IStatus readRepositoryTemplate(IConfigurationElement element) {
        String label = element.getAttribute(ELMNT_TMPL_LABEL);
        String serverUrl = element.getAttribute(ELMNT_TMPL_URLREPOSITORY);
        String repKind = element.getAttribute(ELMNT_TMPL_REPOSITORYKIND);
        String version = element.getAttribute(ELMNT_TMPL_VERSION);
        String newTaskUrl = element.getAttribute(ELMNT_TMPL_URLNEWTASK);
        String taskPrefix = element.getAttribute(ELMNT_TMPL_URLTASK);
        String taskQueryUrl = element.getAttribute(ELMNT_TMPL_URLTASKQUERY);
        String newAccountUrl = element.getAttribute(ELMNT_TMPL_NEWACCOUNTURL);
        String encoding = element.getAttribute(ELMNT_TMPL_CHARACTERENCODING);
        boolean addAuto = Boolean.parseBoolean(element.getAttribute(ELMNT_TMPL_ADDAUTO));
        boolean anonymous = Boolean.parseBoolean(element.getAttribute(ELMNT_TMPL_ANONYMOUS));
        if (serverUrl != null && label != null && repKind != null && this.repositoryManager.getRepositoryConnector(repKind) != null) {
            RepositoryTemplate template = new RepositoryTemplate(label, serverUrl, encoding, version, newTaskUrl, taskPrefix, taskQueryUrl, newAccountUrl, anonymous, addAuto);
            IConfigurationElement[] iConfigurationElementArray = element.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configElement = iConfigurationElementArray[n2];
                String name = configElement.getAttribute("name");
                String value = configElement.getAttribute("value");
                if (name != null && name.length() > 0 && value != null) {
                    template.addAttribute(name, value);
                }
                ++n2;
            }
            this.templateManager.addTemplate(repKind, template);
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.mylyn.tasks.core", NLS.bind((String)"Could not load repository template extension contributed by ''{0}'' with connectorKind ''{1}''", (Object)element.getNamespaceIdentifier(), (Object)repKind));
    }
}

