/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.asciidoc.internal.block;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.asciidoc.AsciiDocLanguage;
import org.eclipse.mylyn.wikitext.asciidoc.internal.AsciiDocContentState;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.markup.AbstractMarkupLanguage;
import org.eclipse.mylyn.wikitext.parser.markup.ContentState;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.parser.markup.block.AbstractTableOfContentsBlock;
import org.eclipse.mylyn.wikitext.parser.outline.OutlineItem;
import org.eclipse.mylyn.wikitext.parser.outline.OutlineParser;

public class TableOfContentsBlock
extends AbstractTableOfContentsBlock {
    private static final int tocLevelDefault = 2;
    private static final int tocLevelMax = 5;
    private static final Pattern startPattern = Pattern.compile("toc::\\[\\]\\s*");
    private int blockLineNumber;

    protected int processLineContent(String line, int offset) {
        if (this.blockLineNumber++ > 0) {
            this.setClosed(true);
            return 0;
        }
        String tocAttribute = this.getAsciiDocState().getAttribute("toc");
        if ("macro".equals(tocAttribute)) {
            this.emitFullToc();
        }
        return -1;
    }

    public void emitFullToc() {
        if (!this.getMarkupLanguage().isFilterGenerativeContents()) {
            this.setMaxLevel(1 + this.getTocLevelsAttribute());
            String tocTitle = this.getAsciiDocState().getAttribute("toc-title");
            OutlineParser outlineParser = new OutlineParser((MarkupLanguage)new AsciiDocLanguage());
            OutlineItem rootItem = outlineParser.parse(this.state.getMarkupContent());
            List zeroLevelItems = rootItem.getChildren();
            if (zeroLevelItems.size() > 0) {
                this.emitTocTitle(tocTitle);
                this.emitToc((OutlineItem)zeroLevelItems.get(0));
            }
        }
    }

    private void emitTocTitle(String tocTitle) {
        if (tocTitle != null) {
            Attributes attributes = new Attributes();
            attributes.setCssClass("title");
            this.builder.beginBlock(DocumentBuilder.BlockType.DIV, attributes);
            this.builder.characters(tocTitle);
            this.builder.endBlock();
        }
    }

    private int getTocLevelsAttribute() {
        int tocLevel = 2;
        try {
            tocLevel = Integer.parseInt(this.getAsciiDocState().getAttributeOrValue("toclevels", Integer.toString(2)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Math.min(tocLevel, 5);
    }

    public boolean canStart(String line, int lineOffset) {
        if (lineOffset == 0 && startPattern.matcher(line).matches() && !this.getMarkupLanguage().isFilterGenerativeContents()) {
            this.blockLineNumber = 0;
            return true;
        }
        return false;
    }

    public TableOfContentsBlock cloneAndStart(AbstractMarkupLanguage markup, MarkupParser parser, ContentState state) {
        TableOfContentsBlock tocBlock = (TableOfContentsBlock)this.clone();
        tocBlock.blockLineNumber = 0;
        tocBlock.markupLanguage = markup;
        tocBlock.setParser(parser);
        tocBlock.setState(state);
        return tocBlock;
    }

    private AsciiDocContentState getAsciiDocState() {
        return (AsciiDocContentState)this.state;
    }
}

