/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers.ui.quickfix;

import org.eclipse.cdt.codan.core.cxx.CxxAstUtils;
import org.eclipse.cdt.codan.internal.checkers.ui.CheckersUiActivator;
import org.eclipse.cdt.codan.internal.checkers.ui.quickfix.QuickFixMessages;
import org.eclipse.cdt.codan.ui.AbstractAstRewriteQuickFix;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;

public class QuickFixCreateField
extends AbstractAstRewriteQuickFix {
    public String getLabel() {
        return QuickFixMessages.QuickFixCreateField_create_field;
    }

    public void modifyAST(IIndex index, IMarker marker) {
        try {
            IASTTranslationUnit ast = this.getTranslationUnitViaEditor(marker).getAST(index, 2);
            IASTName astName = this.getASTNameFromMarker(marker, ast);
            if (astName == null) {
                return;
            }
            IASTDeclaration declaration = CxxAstUtils.createDeclaration((IASTName)astName, (INodeFactory)ast.getASTNodeFactory(), (IIndex)index);
            IASTCompositeTypeSpecifier targetCompositeType = CxxAstUtils.getEnclosingCompositeTypeSpecifier((IASTNode)astName);
            if (targetCompositeType == null && (targetCompositeType = CxxAstUtils.getCompositeTypeFromFunction((IASTFunctionDefinition)CxxAstUtils.getEnclosingFunction((IASTNode)astName), (IIndex)index)) == null) {
                return;
            }
            ASTRewrite r = ASTRewrite.create((IASTTranslationUnit)targetCompositeType.getTranslationUnit());
            IASTNode where = this.findInsertionPlace(targetCompositeType);
            r.insertBefore((IASTNode)targetCompositeType, where, (IASTNode)declaration, null);
            Change c = r.rewriteAST();
            c.perform((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            CheckersUiActivator.log(e);
        }
    }

    protected IASTNode findInsertionPlace(IASTCompositeTypeSpecifier composite) {
        IASTNode[] children;
        boolean wantPublicContext = composite.getKey() != 3;
        boolean inDesiredAccessibilityContext = true;
        IASTNode bestMatch = null;
        IASTNode[] iASTNodeArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode child = iASTNodeArray[n2];
            if (!(child instanceof IASTName) && !(child instanceof ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier)) {
                bestMatch = child;
                break;
            }
            ++n2;
        }
        int i = 0;
        while (i < children.length) {
            IASTNode child = children[i];
            if (child instanceof ICPPASTVisibilityLabel) {
                ICPPASTVisibilityLabel label = (ICPPASTVisibilityLabel)child;
                inDesiredAccessibilityContext = wantPublicContext && label.getVisibility() == 1 || !wantPublicContext && label.getVisibility() == 3;
            } else if (inDesiredAccessibilityContext && child instanceof IASTDeclaration && !(child instanceof IASTFunctionDefinition)) {
                IASTNode[] iASTNodeArray2 = child.getChildren();
                int n3 = iASTNodeArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IASTNode gchild = iASTNodeArray2[n4];
                    if (gchild instanceof IASTDeclarator && !(gchild instanceof IASTFunctionDeclarator)) {
                        bestMatch = i + 1 < children.length ? children[i + 1] : null;
                        break;
                    }
                    ++n4;
                }
            }
            ++i;
        }
        return bestMatch;
    }

    public boolean isApplicable(IMarker marker) {
        String problemArgument = this.getProblemArgument(marker, 1);
        return problemArgument.contains(":class") && problemArgument.contains(":func");
    }
}

