/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.branch;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.core.op.DeleteBranchOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.UnmergedBranchDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.PlatformUI;

public class DeleteBranchOperationUI {
    public static void deleteBranches(Map<Repository, ? extends Collection<Ref>> toDelete) throws InvocationTargetException {
        HashMap<Repository, List<Ref>> map = new HashMap<Repository, List<Ref>>();
        int[] total = new int[1];
        toDelete.forEach((repo, list) -> {
            if (!list.isEmpty()) {
                map.put((Repository)repo, new ArrayList(list));
                nArray[0] = total[0] + list.size();
            }
        });
        if (total[0] > 0) {
            DeleteBranchOperationUI.deleteBranchesImpl(map, total[0]);
        }
    }

    public static void deleteBranches(Repository repository, Collection<Ref> toDelete) throws InvocationTargetException {
        if (toDelete.isEmpty()) {
            return;
        }
        HashMap<Repository, List<Ref>> map = new HashMap<Repository, List<Ref>>();
        map.put(repository, new ArrayList<Ref>(toDelete));
        DeleteBranchOperationUI.deleteBranchesImpl(map, toDelete.size());
    }

    private static void deleteBranchesImpl(Map<Repository, List<Ref>> toDelete, int numberOfRefs) throws InvocationTargetException {
        ArrayList<Ref> unmergedRefs = new ArrayList<Ref>();
        IShellProvider shell = PlatformUI.getWorkbench().getModalDialogShellProvider();
        try {
            new ProgressMonitorDialog(shell.getShell()).run(true, true, monitor -> DeleteBranchOperationUI.deleteBranches(toDelete, (List<Ref>)unmergedRefs, false, numberOfRefs, monitor));
        }
        catch (InterruptedException e) {
            return;
        }
        if (unmergedRefs.isEmpty()) {
            return;
        }
        UnmergedBranchDialog messageDialog = new UnmergedBranchDialog(shell.getShell(), unmergedRefs);
        if (messageDialog.open() != 0) {
            return;
        }
        int remainingRefs = numberOfRefs - unmergedRefs.size();
        try {
            new ProgressMonitorDialog(shell.getShell()).run(true, true, monitor -> DeleteBranchOperationUI.deleteBranches(toDelete, null, true, remainingRefs, monitor));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void deleteBranches(Map<Repository, List<Ref>> refs, List<Ref> unmerged, boolean forceDeletionOfUnmergedBranches, int numberOfRefs, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)UIText.DeleteBranchCommand_DeletingBranchesProgress, (int)numberOfRefs);
            Iterator<Map.Entry<Repository, List<Ref>>> entries = refs.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<Repository, List<Ref>> entry = entries.next();
                List<Ref> toDelete = entry.getValue();
                try {
                    DeleteBranchOperationUI.deleteBranches(entry.getKey(), toDelete, unmerged, forceDeletionOfUnmergedBranches, progress.newChild(toDelete.size()));
                    if (!toDelete.isEmpty()) continue;
                    entries.remove();
                }
                catch (OperationCanceledException e) {
                    throw new InterruptedException();
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private static void deleteBranches(Repository repo, List<Ref> refs, List<Ref> unmerged, boolean forceDeletionOfUnmergedBranches, SubMonitor progress) throws CoreException {
        Iterator<Ref> toDelete = refs.iterator();
        while (toDelete.hasNext()) {
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            Ref ref = toDelete.next();
            int result = DeleteBranchOperationUI.deleteBranch(repo, ref, forceDeletionOfUnmergedBranches);
            if (result == 1) {
                throw new CoreException(Activator.createErrorStatus(UIText.DeleteBranchCommand_CannotDeleteCheckedOutBranch, null));
            }
            if (result == 2) {
                if (unmerged == null) continue;
                unmerged.add(ref);
                continue;
            }
            toDelete.remove();
            progress.worked(1);
        }
    }

    private static int deleteBranch(Repository repo, Ref ref, boolean force) throws CoreException {
        DeleteBranchOperation op = new DeleteBranchOperation(repo, ref, force);
        op.execute(null);
        return op.getStatus();
    }
}

