/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class BooleanLiteralCleanUpCore
extends AbstractMultiFix
implements ICleanUpFix {
    public BooleanLiteralCleanUpCore() {
        this(Collections.emptyMap());
    }

    public BooleanLiteralCleanUpCore(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.boolean_literal");
        return new CleanUpRequirements(requireAST, false, false, null);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.boolean_literal")) {
            return new String[]{MultiFixMessages.BooleanLiteralCleanup_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.boolean_literal")) {
            return "boolean isActive = true;\n";
        }
        return "boolean isActive = Boolean.TRUE;\n";
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit) throws CoreException {
        if (!this.isEnabled("cleanup.boolean_literal")) {
            return null;
        }
        final ArrayList rewriteOperations = new ArrayList();
        unit.accept(new ASTVisitor(){

            public boolean visit(QualifiedName node) {
                ITypeBinding typeBinding = ASTNodes.getTargetType((Expression)node);
                if (typeBinding != null && typeBinding.isPrimitive()) {
                    if (ASTNodes.isField(node, Boolean.class.getCanonicalName(), "TRUE")) {
                        rewriteOperations.add(new BooleanLiteralOperation(node, true));
                        return false;
                    }
                    if (ASTNodes.isField(node, Boolean.class.getCanonicalName(), "FALSE")) {
                        rewriteOperations.add(new BooleanLiteralOperation(node, false));
                        return false;
                    }
                }
                return true;
            }
        });
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.BooleanLiteralCleanup_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange[0]));
    }

    @Override
    public CompilationUnitChange createChange(IProgressMonitor progressMonitor) throws CoreException {
        return null;
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        return false;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    private static class BooleanLiteralOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange {
        private final QualifiedName node;
        private final boolean value;

        public BooleanLiteralOperation(QualifiedName node, boolean value) {
            this.node = node;
            this.value = value;
        }

        @Override
        public void rewriteASTInternal(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.BooleanLiteralCleanup_description, cuRewrite);
            BooleanLiteral booleanLiteral = ast.newBooleanLiteral(this.value);
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.node, (ASTNode)booleanLiteral, group);
        }
    }
}

