/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.dnd;

import aQute.bnd.maven.MavenCapability;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.pde.bnd.ui.dnd.GAVDropTargetListener;
import org.eclipse.swt.custom.StyledText;
import org.osgi.resource.Resource;

public class MavenDropTargetListener
extends GAVDropTargetListener {
    private static final IPreferencesService prefsService = Platform.getPreferencesService();

    public MavenDropTargetListener(StyledText styledText) {
        super(styledText);
    }

    @Override
    void format(GAVDropTargetListener.FormatEvent formatEvent) {
        if (formatEvent.isNoVersion()) {
            this.format(formatEvent.getResource(), Syntax.MAVEN_NO_VERSION, formatEvent.getLineAtInsertionPoint(), formatEvent.getIndentPrefix(), MavenDropTargetListener.indent(this.isTabs(), this.getSize()));
        } else {
            this.format(formatEvent.getResource(), Syntax.MAVEN, formatEvent.getLineAtInsertionPoint(), formatEvent.getIndentPrefix(), MavenDropTargetListener.indent(this.isTabs(), this.getSize()));
        }
    }

    @Override
    boolean hasAlternateSyntax() {
        return false;
    }

    int getSize() {
        if (this.isTabs()) {
            return 1;
        }
        return prefsService.getInt("org.eclipse.wst.xml.core.prefs", "indentationSize", 4, null);
    }

    boolean isTabs() {
        return prefsService.getString("org.eclipse.wst.xml.core.prefs", "indentationChar", "tab", null).equals("tab");
    }

    private void format(Resource resource, Syntax syntax, String lineAtInsertionPoint, String indentPrefix, String indent) {
        MavenCapability mc = MavenCapability.getMavenCapability((Resource)resource);
        if (mc == null) {
            return;
        }
        if (lineAtInsertionPoint.trim().startsWith("<dependencies>")) {
            indentPrefix = (String)indentPrefix + indent;
        }
        String group = mc.maven_groupId();
        String identity = mc.maven_artifactId();
        String version = mc.maven_version().toString();
        String classifier = mc.maven_classifier();
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append((String)indentPrefix).append("<dependency>\n").append((String)indentPrefix).append(indent).append("<groupId>").append(group).append("</groupId>\n").append((String)indentPrefix).append(indent).append("<artifactId>").append(identity).append("</artifactId>\n");
        if (classifier != null && !classifier.isBlank()) {
            sb.append((String)indentPrefix).append(indent).append("<classifier>").append(version).append("</classifier>\n");
        }
        switch (syntax) {
            case MAVEN: {
                sb.append((String)indentPrefix).append(indent).append("<version>").append(version).append("</version>\n");
                break;
            }
        }
        sb.append((String)indentPrefix).append("</dependency>");
        this.getStyledText().insert(sb.toString());
    }

    static enum Syntax {
        MAVEN,
        MAVEN_NO_VERSION;

    }
}

