/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit.command;

import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.op.EditCommitOperation;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIRepositoryUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.handler.SelectionHandler;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;

public class EditHandler
extends SelectionHandler {
    public static final String ID = "org.eclipse.egit.ui.commit.Edit";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        RevCommit commit = this.getSelectedItem(RevCommit.class, event);
        if (commit == null) {
            return null;
        }
        Repository repo = this.getSelectedItem(Repository.class, event);
        if (repo == null) {
            return null;
        }
        Shell shell = this.getPart(event).getSite().getShell();
        EditHandler.editCommit(commit, repo, shell);
        return null;
    }

    public static boolean editCommit(RevCommit commit, Repository repo, Shell shell) {
        try {
            if (!UIRepositoryUtils.handleUncommittedFiles(repo, shell)) {
                return false;
            }
        }
        catch (GitAPIException e) {
            Activator.logError(e.getMessage(), e);
            return false;
        }
        EditCommitOperation op = new EditCommitOperation(repo, commit);
        JobUtil.scheduleUserWorkspaceJob((IEGitOperation)op, (String)MessageFormat.format(UIText.EditHandler_JobName, commit.name()), (Object)JobFamilies.EDIT);
        return true;
    }
}

