/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.text.java.correction;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.manipulation.CUCorrectionProposalCore;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class ASTRewriteCorrectionProposalCore
extends CUCorrectionProposalCore {
    private ASTRewrite fRewrite;
    private ImportRewrite fImportRewrite;

    public ASTRewriteCorrectionProposalCore(String name, ICompilationUnit cu, ASTRewrite rewrite, int relevance) {
        super(name, cu, relevance);
        this.fRewrite = rewrite;
    }

    public ImportRewrite getImportRewrite() {
        return this.fImportRewrite;
    }

    public void setImportRewrite(ImportRewrite rewrite) {
        this.fImportRewrite = rewrite;
    }

    public ImportRewrite createImportRewrite(CompilationUnit astRoot) {
        this.fImportRewrite = StubUtility.createImportRewrite(astRoot, true);
        return this.fImportRewrite;
    }

    @Override
    public void addEdits(IDocument document, TextEdit editRoot) throws CoreException {
        super.addEdits(document, editRoot);
        ASTRewrite rewrite = this.getRewrite();
        if (rewrite != null) {
            try {
                TextEdit edit = rewrite.rewriteAST();
                editRoot.addChild(edit);
            }
            catch (IllegalArgumentException e) {
                throw new CoreException(JavaUIStatus.createError(4, e));
            }
        }
        if (this.fImportRewrite != null) {
            editRoot.addChild(this.fImportRewrite.rewriteImports((IProgressMonitor)new NullProgressMonitor()));
        }
    }

    protected ASTRewrite getRewrite() throws CoreException {
        if (this.fRewrite == null) {
            IStatus status = JavaUIStatus.createError(4, "Rewrite not initialized", null);
            throw new CoreException(status);
        }
        return this.fRewrite;
    }
}

