/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.genericeditor.target.extension.model;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.genericeditor.target.extension.p2.Messages;
import org.eclipse.pde.internal.genericeditor.target.extension.p2.P2Fetcher;

public class RepositoryCache {
    private static final Map<URI, CompletableFuture<RepositoryMetadata>> CACHE = new ConcurrentHashMap<URI, CompletableFuture<RepositoryMetadata>>();
    private static final Comparator<IVersionedId> BY_ID_FIRST_THEN_DESCENDING_VERSION = Comparator.comparing(IVersionedId::getId, String.CASE_INSENSITIVE_ORDER).thenComparing(IVersionedId::getVersion, Comparator.reverseOrder());

    private RepositoryCache() {
    }

    public static Map<String, List<IVersionedId>> fetchP2UnitsFromRepos(List<String> repositories) {
        if (repositories.size() == 1) {
            return RepositoryCache.getFutureValue(RepositoryCache.fetchP2DataOfRepo(repositories.get(0)), RepositoryMetadata::units, Map.of());
        }
        List<Future> repos = repositories.stream().map(RepositoryCache::fetchP2DataOfRepo).toList();
        return RepositoryCache.toSortedMap(repos.stream().map(r -> RepositoryCache.getFutureValue(r, RepositoryMetadata::units, Map.of())).map(Map::values).flatMap(Collection::stream).flatMap(Collection::stream));
    }

    public static List<URI> fetchChildrenOfRepo(String repository) {
        return RepositoryCache.getFutureValue(RepositoryCache.fetchP2DataOfRepo(repository), RepositoryMetadata::children, List.of());
    }

    public static void prefetchP2MetadataOfRepository(String repository) {
        RepositoryCache.fetchP2DataOfRepo(repository);
    }

    private static Future<RepositoryMetadata> fetchP2DataOfRepo(String repository) {
        URI location;
        try {
            location = new URI(repository + (repository.endsWith("/") ? "" : "/"));
        }
        catch (URISyntaxException e) {
            return CompletableFuture.failedFuture(e);
        }
        return CACHE.compute(location, (repo, f) -> {
            if (!(f == null || f.isDone() && (f.isCompletedExceptionally() || f.isCancelled()))) {
                return f;
            }
            CompletableFuture future = new CompletableFuture();
            Job job = Job.create((String)NLS.bind((String)Messages.UpdateJob_P2DataFetch, (Object)repo), m -> {
                try {
                    P2Fetcher.RepositoryContent content = P2Fetcher.fetchAvailableUnits(repo, m);
                    Map<String, List<IVersionedId>> units = RepositoryCache.toSortedMap(content.units().stream().map(iu -> new VersionedId(iu.getId(), iu.getVersion())));
                    future.complete(new RepositoryMetadata(units, content.children()));
                }
                catch (Throwable e) {
                    future.completeExceptionally(e);
                    ILog.get().warn(e.getMessage(), e);
                }
            });
            job.setUser(true);
            job.schedule();
            return future;
        });
    }

    private static Map<String, List<IVersionedId>> toSortedMap(Stream<IVersionedId> units) {
        return units.sorted(BY_ID_FIRST_THEN_DESCENDING_VERSION).collect(Collectors.groupingBy(IVersionedId::getId, LinkedHashMap::new, Collectors.toUnmodifiableList()));
    }

    private static <T> T getFutureValue(Future<RepositoryMetadata> future, Function<RepositoryMetadata, T> getter, T defaultValue) {
        try {
            return getter.apply(future.get());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static List<IVersionedId> getUnitsByPrefix(String repo, String prefix) {
        Map<String, List<IVersionedId>> allUnits = RepositoryCache.fetchP2UnitsFromRepos(List.of(repo));
        return allUnits.values().stream().flatMap(Collection::stream).filter(unit -> unit.getId().startsWith(prefix)).toList();
    }

    public static List<IVersionedId> getUnitsBySearchTerm(String repo, String searchTerm) {
        Map<String, List<IVersionedId>> allUnits = RepositoryCache.fetchP2UnitsFromRepos(List.of(repo));
        return allUnits.values().stream().flatMap(Collection::stream).filter(unit -> unit.getId().contains(searchTerm)).toList();
    }

    private record RepositoryMetadata(Map<String, List<IVersionedId>> units, List<URI> children) {
    }
}

