/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.suite.engine;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;
import org.junit.platform.suite.api.AfterSuite;
import org.junit.platform.suite.api.BeforeSuite;

final class LifecycleMethodUtils {
    private LifecycleMethodUtils() {
    }

    static List<Method> findBeforeSuiteMethods(Class<?> testClass, DiscoveryIssueReporter issueReporter) {
        return LifecycleMethodUtils.findMethodsAndCheckStaticAndNonPrivate(testClass, BeforeSuite.class, HierarchyTraversalMode.TOP_DOWN, issueReporter);
    }

    static List<Method> findAfterSuiteMethods(Class<?> testClass, DiscoveryIssueReporter issueReporter) {
        return LifecycleMethodUtils.findMethodsAndCheckStaticAndNonPrivate(testClass, AfterSuite.class, HierarchyTraversalMode.BOTTOM_UP, issueReporter);
    }

    private static List<Method> findMethodsAndCheckStaticAndNonPrivate(Class<?> testClass, Class<? extends Annotation> annotationType, HierarchyTraversalMode traversalMode, DiscoveryIssueReporter issueReporter) {
        return AnnotationSupport.findAnnotatedMethods(testClass, annotationType, (HierarchyTraversalMode)traversalMode).stream().filter(LifecycleMethodUtils.returnsPrimitiveVoid(annotationType, issueReporter).and(LifecycleMethodUtils.isStatic(annotationType, issueReporter)).and(LifecycleMethodUtils.isNotPrivate(annotationType, issueReporter)).and(LifecycleMethodUtils.hasNoParameters(annotationType, issueReporter)).toPredicate()).toList();
    }

    private static DiscoveryIssueReporter.Condition<Method> isStatic(Class<? extends Annotation> annotationType, DiscoveryIssueReporter issueReporter) {
        return issueReporter.createReportingCondition(ModifierSupport::isStatic, method -> {
            String message = "@%s method '%s' must be static.".formatted(annotationType.getSimpleName(), method.toGenericString());
            return LifecycleMethodUtils.createError(message, method);
        });
    }

    private static DiscoveryIssueReporter.Condition<Method> isNotPrivate(Class<? extends Annotation> annotationType, DiscoveryIssueReporter issueReporter) {
        return issueReporter.createReportingCondition(ModifierSupport::isNotPrivate, method -> {
            String message = "@%s method '%s' must not be private.".formatted(annotationType.getSimpleName(), method.toGenericString());
            return LifecycleMethodUtils.createError(message, method);
        });
    }

    private static DiscoveryIssueReporter.Condition<Method> returnsPrimitiveVoid(Class<? extends Annotation> annotationType, DiscoveryIssueReporter issueReporter) {
        return issueReporter.createReportingCondition(ReflectionUtils::returnsPrimitiveVoid, method -> {
            String message = "@%s method '%s' must not return a value.".formatted(annotationType.getSimpleName(), method.toGenericString());
            return LifecycleMethodUtils.createError(message, method);
        });
    }

    private static DiscoveryIssueReporter.Condition<Method> hasNoParameters(Class<? extends Annotation> annotationType, DiscoveryIssueReporter issueReporter) {
        return issueReporter.createReportingCondition(method -> method.getParameterCount() == 0, method -> {
            String message = "@%s method '%s' must not accept parameters.".formatted(annotationType.getSimpleName(), method.toGenericString());
            return LifecycleMethodUtils.createError(message, method);
        });
    }

    private static DiscoveryIssue createError(String message, Method method) {
        return DiscoveryIssue.builder((DiscoveryIssue.Severity)DiscoveryIssue.Severity.ERROR, (String)message).source((TestSource)MethodSource.from((Method)method)).build();
    }
}

