/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.internal.core.target.RepositoryBundleContainer;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.shared.target.RepositoryLocationWizard;
import org.eclipse.pde.ui.target.ITargetLocationHandler;
import org.eclipse.swt.graphics.Image;
import org.osgi.resource.Requirement;

public class RepositoryBundleContainerAdapterFactory
implements IAdapterFactory {
    private static final Object[] EMPTY_OBJECTS = new Object[0];
    public static final ILabelProvider LABEL_PROVIDER = new LabelProvider(){
        private Image repositoryImage;
        private Image requirementImage;

        public String getText(Object element) {
            if (element instanceof RepositoryBundleContainer) {
                RepositoryBundleContainer container = (RepositoryBundleContainer)element;
                try {
                    return container.getLocation(true);
                }
                catch (CoreException e) {
                    return container.getUri();
                }
            }
            if (element instanceof RequirementNode) {
                RequirementNode requirement = (RequirementNode)element;
                return requirement.requirement().toString();
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof RepositoryBundleContainer) {
                if (this.repositoryImage == null) {
                    this.repositoryImage = PDEPluginImages.DESC_TARGET_REPO.createImage();
                }
                return this.repositoryImage;
            }
            if (element instanceof RequirementNode) {
                if (this.requirementImage == null) {
                    this.requirementImage = PDEPluginImages.DESC_FILTER.createImage();
                }
                return this.requirementImage;
            }
            return null;
        }

        public void dispose() {
            super.dispose();
            if (this.repositoryImage != null) {
                this.repositoryImage.dispose();
                this.repositoryImage = null;
            }
        }
    };
    private static final ITargetLocationHandler LOCATION_HANDLER = new ITargetLocationHandler(){

        @Override
        public IStatus reload(ITargetDefinition target, ITargetLocation[] targetLocations, IProgressMonitor monitor) {
            ITargetLocation[] iTargetLocationArray = targetLocations;
            int n = targetLocations.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation location = iTargetLocationArray[n2];
                if (location instanceof RepositoryBundleContainer) {
                    RepositoryBundleContainer container = (RepositoryBundleContainer)location;
                    container.reload();
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }

        @Override
        public IWizard getEditWizard(ITargetDefinition target, TreePath treePath) {
            Object segment = treePath.getLastSegment();
            if (segment instanceof RequirementNode) {
                RequirementNode node = (RequirementNode)segment;
                segment = node.container;
            }
            if (segment instanceof RepositoryBundleContainer) {
                RepositoryBundleContainer container = (RepositoryBundleContainer)segment;
                RepositoryLocationWizard wizard = new RepositoryLocationWizard();
                wizard.setTarget(target);
                wizard.setBundleContainer(container);
                return wizard;
            }
            return null;
        }

        @Override
        public boolean canEdit(ITargetDefinition target, TreePath treePath) {
            Object segment = treePath.getLastSegment();
            return segment instanceof RepositoryBundleContainer || segment instanceof RequirementNode;
        }

        @Override
        public boolean canRemove(ITargetDefinition target, TreePath treePath) {
            return treePath.getLastSegment() instanceof RequirementNode;
        }

        @Override
        public IStatus remove(ITargetDefinition target, TreePath[] treePaths) {
            boolean reload = false;
            TreePath[] treePathArray = treePaths;
            int n = treePaths.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                Object lastSegment = path.getLastSegment();
                if (lastSegment instanceof RequirementNode) {
                    RequirementNode node = (RequirementNode)lastSegment;
                    RepositoryBundleContainer container = node.container;
                    RepositoryBundleContainer newContainer = new RepositoryBundleContainer(container.getUri(), container.getRequirements().stream().filter(req -> req != node.requirement()).toList());
                    ITargetLocation[] targetLocations = target.getTargetLocations();
                    int i = 0;
                    while (i < targetLocations.length) {
                        ITargetLocation loc = targetLocations[i];
                        if (loc == container) {
                            targetLocations[i] = newContainer;
                        }
                        ++i;
                    }
                }
                ++n2;
            }
            return reload ? new Status(0, "org.eclipse.pde.ui", 102, "reloaded", null) : Status.OK_STATUS;
        }
    };
    private static final ITreeContentProvider TREE_CONTENT_PROVIDER = new ITreeContentProvider(){

        public boolean hasChildren(Object element) {
            if (element instanceof RepositoryBundleContainer) {
                RepositoryBundleContainer container = (RepositoryBundleContainer)element;
                return !container.getRequirements().isEmpty();
            }
            return false;
        }

        public Object getParent(Object element) {
            if (element instanceof RequirementNode) {
                RequirementNode node = (RequirementNode)element;
                return node.container;
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            return EMPTY_OBJECTS;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof RepositoryBundleContainer) {
                RepositoryBundleContainer container = (RepositoryBundleContainer)parentElement;
                return container.getRequirements().stream().map(req -> new RequirementNode((Requirement)req, container)).toArray();
            }
            return EMPTY_OBJECTS;
        }
    };

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adaptableObject instanceof RepositoryBundleContainer || adaptableObject instanceof RequirementNode) {
            if (adapterType == ILabelProvider.class) {
                return adapterType.cast(LABEL_PROVIDER);
            }
            if (adapterType == ITargetLocationHandler.class) {
                return adapterType.cast(LOCATION_HANDLER);
            }
            if (adapterType == ITreeContentProvider.class) {
                return adapterType.cast(TREE_CONTENT_PROVIDER);
            }
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{ILabelProvider.class, ITargetLocationHandler.class, ITreeContentProvider.class};
    }

    public record RequirementNode(Requirement requirement, RepositoryBundleContainer container) {
    }
}

