/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.tasks.maven;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.providers.file.FileWagon;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.wagon.WagonProvider;
import org.eclipse.aether.transport.wagon.WagonTransporterFactory;
import org.eclipse.core.internal.variables.StringVariableManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.apt.core.util.IFactoryPath;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.tea.core.services.TaskProgressTracker;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.library.build.config.BuildDirectories;
import org.eclipse.tea.library.build.config.TeaBuildConfig;
import org.eclipse.tea.library.build.model.MavenExternalJarBuild;
import org.eclipse.tea.library.build.model.PluginBuild;
import org.eclipse.tea.library.build.model.PluginData;
import org.eclipse.tea.library.build.model.WorkspaceBuild;
import org.eclipse.tea.library.build.tasks.maven.ConsoleRepositoryListener;
import org.eclipse.tea.library.build.tasks.maven.ConsoleTransferListener;
import org.eclipse.tea.library.build.util.FileUtils;
import org.eclipse.tea.library.build.util.StringHelper;

public class SynchronizeMavenArtifact {
    private static final RepositoryPolicy DISABLED_POLICY = new RepositoryPolicy(false, null, null);
    private static final RepositoryPolicy RELEASE_POLICY = new RepositoryPolicy(true, "daily", "warn");
    private static final RepositoryPolicy SNAPSHOT_POLICY = new RepositoryPolicy(true, "always", "warn");
    private static final String MAVEN_DIRNAME = "maven";
    private static final String CLASSIFIER_SOURCES = "sources";
    private String lastExceptionName;
    private MavenConfig properties;

    public String toString() {
        return "Synchronize Maven";
    }

    private void info(TaskingLog log, String msg) {
        log.info(this.toString() + ": " + msg);
    }

    @Execute
    public void run(TaskingLog log, TaskProgressTracker tracker, TeaBuildConfig cfg, WorkspaceBuild wb) throws Exception {
        this.properties = SynchronizeMavenArtifact.getMavenConfig(log, cfg);
        if (this.properties == null) {
            return;
        }
        ResourcesPlugin.getWorkspace().run(m -> this.runOperation(log, tracker, cfg, wb), null);
    }

    private void runOperation(TaskingLog log, TaskProgressTracker tracker, TeaBuildConfig cfg, WorkspaceBuild wb) throws CoreException {
        IndexManager indexManager = JavaModelManager.getIndexManager();
        this.lastExceptionName = null;
        boolean needIndexerDisable = false;
        try {
            try {
                ServiceLocator locator = SynchronizeMavenArtifact.createServiceLocator(log);
                RepositorySystem system = (RepositorySystem)locator.getService(RepositorySystem.class);
                DefaultRepositorySystemSession session = this.createSession(log, system);
                List<RemoteRepository> remotes = this.createRemoteRepositories();
                HashSet<BatchableMavenManipulator> mavenManips = new HashSet<BatchableMavenManipulator>();
                for (PluginBuild pb : wb.getSourcePlugIns()) {
                    if (pb.getMavenExternalJarDependencies().isEmpty() || ((PluginData)pb.getData()).isBinary()) continue;
                    mavenManips.add(new BatchableMavenManipulator(log, tracker, system, (RepositorySystemSession)session, remotes, pb));
                }
                for (BatchableMavenManipulator mavenManip : mavenManips) {
                    mavenManip.identifyFilesToUpdate();
                }
                for (BatchableMavenManipulator mavenManip : mavenManips) {
                    if (mavenManip.getFilesToClean().isEmpty()) continue;
                    needIndexerDisable = true;
                    break;
                }
                ResourcesPlugin.getWorkspace().checkpoint(false);
                if (needIndexerDisable) {
                    tracker.setTaskName("closing workspace files that are updated");
                    this.info(log, "closing workspace files that are updated");
                    indexManager.disable();
                    mavenManips.forEach(m -> m.getFilesToClean().forEach(f -> indexManager.discardJobs(f.getFullPath().toString())));
                    AptConfig.setFactoryPath(null, (IFactoryPath)AptConfig.getFactoryPath(null));
                    System.gc();
                    System.runFinalization();
                }
                mavenManips.forEach(BatchableMavenManipulator::synchronizeArtifacts);
                tracker.setTaskName("finalizing");
                this.info(log, "finalizing");
                if (needIndexerDisable) {
                    needIndexerDisable = false;
                    indexManager.enable();
                }
                for (BatchableMavenManipulator mavenManip : mavenManips) {
                    mavenManip.refreshWorkspace();
                }
            }
            catch (OperationCanceledException e) {
                this.info(log, "cancelled");
                throw e;
            }
            catch (Exception e) {
                log.error("error synchronizing maven artifacts", (Throwable)e);
                if (needIndexerDisable) {
                    indexManager.enable();
                }
                ResourcesPlugin.getWorkspace().checkpoint(false);
            }
        }
        finally {
            if (needIndexerDisable) {
                indexManager.enable();
            }
            ResourcesPlugin.getWorkspace().checkpoint(false);
        }
    }

    private static void checkCanceled(TaskProgressTracker tracker) {
        if (tracker.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public static MavenConfig getMavenConfig(TaskingLog log, TeaBuildConfig cfg) throws Exception {
        if (cfg.mavenConfigFilePath == null || StringHelper.isNullOrEmpty(cfg.mavenConfigFilePath)) {
            log.info("Skipping synchronization because no maven configuration has been set");
            return null;
        }
        String expanded = StringVariableManager.getDefault().performStringSubstitution(cfg.mavenConfigFilePath);
        File file = new File(expanded);
        if (!file.isAbsolute()) {
            file = new File(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile(), expanded);
        }
        if (!file.exists()) {
            log.warn("Maven configuration file " + String.valueOf(file) + " is missing");
            return null;
        }
        return new MavenConfig(file);
    }

    private static List<ArtifactResult> resolveArtifacts(TaskingLog log, RepositorySystem system, RepositorySystemSession session, Collection<ArtifactRequest> requests) {
        List results;
        try {
            results = system.resolveArtifacts(session, requests);
        }
        catch (ArtifactResolutionException e) {
            results = e.getResults();
        }
        return results;
    }

    private static boolean needUpdateFileInProjectsMavenFolder(IFile targetResource, Artifact artifact) {
        File resolvedFile;
        File targetFile = targetResource.getRawLocation().toFile();
        return !FileUtils.equals(targetFile, resolvedFile = artifact.getFile());
    }

    private void updateFileInProjectsMavenFolder(TaskingLog log, File targetFile, File resolvedFile) {
        if (targetFile.exists() && !targetFile.delete()) {
            log.error("cannot update " + String.valueOf(targetFile) + ". Please make sure file is not locked");
            return;
        }
        try {
            Files.createSymbolicLink(targetFile.toPath(), resolvedFile.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            String exName = e.getClass().getName();
            if (!Objects.equals(exName, this.lastExceptionName)) {
                this.lastExceptionName = exName;
                String msg = e.getMessage();
                if (msg != null) {
                    msg = msg.replace("\n", "\\n");
                    msg = msg.replace("\r", "\\r");
                }
                log.warn("cannot create symlink for: " + String.valueOf(targetFile) + " (" + exName + " " + msg + ")");
            }
            try {
                FileUtils.copyFile(resolvedFile, targetFile);
            }
            catch (IOException copyException) {
                log.error("Could not copy file.", (Throwable)copyException);
                return;
            }
        }
    }

    private List<RemoteRepository> createRemoteRepositories() {
        ArrayList<RemoteRepository> repos = new ArrayList<RemoteRepository>();
        for (Map.Entry<String, String> repo : this.properties.getMavenRepos().entrySet()) {
            RemoteRepository.Builder builder = new RemoteRepository.Builder("nexus_" + repo.getKey(), "default", repo.getValue());
            if (repo.getKey().startsWith("snapshot")) {
                builder.setReleasePolicy(DISABLED_POLICY);
                builder.setSnapshotPolicy(SNAPSHOT_POLICY);
            } else if (repo.getKey().startsWith("release")) {
                builder.setSnapshotPolicy(DISABLED_POLICY);
                builder.setReleasePolicy(RELEASE_POLICY);
            }
            repos.add(builder.build());
        }
        return repos;
    }

    private DefaultRepositorySystemSession createSession(TaskingLog log, RepositorySystem system) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository repo = new LocalRepository(BuildDirectories.get().getMavenDirectory());
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, repo));
        if (this.properties.isVerboseMavenOutput()) {
            session.setTransferListener((TransferListener)new ConsoleTransferListener(log.debug()));
            session.setRepositoryListener((RepositoryListener)new ConsoleRepositoryListener(log.debug()));
        }
        return session;
    }

    private static ServiceLocator createServiceLocator(final TaskingLog log) {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, WagonTransporterFactory.class);
        locator.addService(WagonProvider.class, InternalWagonProvider.class);
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                log.error("cannot create service " + type.getName());
                exception.printStackTrace(log.error());
            }
        });
        return locator;
    }

    private class BatchableMavenManipulator {
        private final TaskingLog log;
        private final TaskProgressTracker tracker;
        private final RepositorySystem system;
        private final RepositorySystemSession session;
        private final List<RemoteRepository> remotes;
        private final PluginBuild hostPlugin;
        private final IFolder targetFolder;
        private final Set<IFile> filesAlreadyUpToDate = new HashSet<IFile>();
        private final Set<IFile> filesToClean = new HashSet<IFile>();
        private final List<ArtifactRequest> artifactRequests = new ArrayList<ArtifactRequest>();
        private final Map<IFile, Artifact> artifactOfFilesToCreate = new HashMap<IFile, Artifact>();
        private final Set<IResource> artifactsToRefresh = new HashSet<IResource>();

        private BatchableMavenManipulator(TaskingLog log, TaskProgressTracker tracker, RepositorySystem system, RepositorySystemSession session, List<RemoteRepository> remotes, PluginBuild hostPlugin) throws CoreException {
            IFile gitignore;
            this.log = log;
            this.tracker = tracker;
            this.system = system;
            this.session = session;
            this.remotes = remotes;
            this.hostPlugin = hostPlugin;
            IProject prj = ((PluginData)hostPlugin.getData()).getProject();
            this.targetFolder = prj.getFolder(SynchronizeMavenArtifact.MAVEN_DIRNAME);
            NullProgressMonitor monitor = new NullProgressMonitor();
            if (!this.targetFolder.exists()) {
                this.targetFolder.create(false, true, (IProgressMonitor)monitor);
                log.warn("creating " + this.targetFolder.getName() + "; make sure to add to the classpath of " + hostPlugin.getPluginName());
            }
            if (!(gitignore = this.targetFolder.getFile(".gitignore")).exists()) {
                gitignore.create((InputStream)new ByteArrayInputStream("*.jar".getBytes(Charset.defaultCharset())), false, null);
            }
            this.filesAlreadyUpToDate.add(gitignore);
        }

        void identifyFilesToUpdate() throws CoreException {
            SynchronizeMavenArtifact.checkCanceled(this.tracker);
            int count = this.hostPlugin.getMavenExternalJarDependencies().size();
            this.tracker.setTaskName("checking artifacts (" + count + ") for " + this.hostPlugin.getPluginName());
            SynchronizeMavenArtifact.this.info(this.log, "check " + count + " artifacts for '" + this.hostPlugin.getPluginName() + "': " + this.hostPlugin.getMavenExternalJarDependencies().stream().map(artifact -> artifact.getCoordinates()).collect(Collectors.joining(", ")));
            for (MavenExternalJarBuild artifact2 : this.hostPlugin.getMavenExternalJarDependencies()) {
                Coordinate coord = new Coordinate(artifact2.getCoordinates());
                this.checkCoordinateForUpdate(coord, coord.classifier);
                if (SynchronizeMavenArtifact.CLASSIFIER_SOURCES.equals(coord.classifier)) continue;
                this.checkCoordinateForUpdate(coord, SynchronizeMavenArtifact.CLASSIFIER_SOURCES);
            }
            IResource[] iResourceArray = this.targetFolder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource file = iResourceArray[n2];
                if (file instanceof IFile && !this.filesAlreadyUpToDate.contains(file)) {
                    this.filesToClean.add((IFile)file);
                }
                ++n2;
            }
        }

        private void checkCoordinateForUpdate(Coordinate coord, String classifier) {
            DefaultArtifact mvn = new DefaultArtifact(coord.group, coord.artifact, classifier, coord.extension, coord.version);
            boolean needDownload = false;
            try {
                ArtifactRequest localrq = new ArtifactRequest().setArtifact((Artifact)mvn);
                ArtifactResult localResult = this.system.resolveArtifact(this.session, localrq);
                Artifact localArtifact = localResult.getArtifact();
                File localFile = localArtifact.getFile();
                if (localResult.isMissing() || !localResult.isResolved() || localArtifact.isSnapshot() || localFile == null) {
                    needDownload = true;
                } else {
                    IFile targetFile = this.targetFolder.getFile(localFile.getName());
                    if (SynchronizeMavenArtifact.needUpdateFileInProjectsMavenFolder(targetFile, localArtifact)) {
                        this.artifactOfFilesToCreate.put(targetFile, localArtifact);
                    } else {
                        this.filesAlreadyUpToDate.add(targetFile);
                    }
                }
            }
            catch (Exception e) {
                needDownload = true;
            }
            if (needDownload) {
                ArtifactRequest remoterq = new ArtifactRequest().setArtifact((Artifact)mvn).setRepositories(this.remotes);
                this.artifactRequests.add(remoterq);
            }
        }

        Collection<IFile> getFilesToClean() {
            return this.filesToClean;
        }

        void synchronizeArtifacts() {
            SynchronizeMavenArtifact.checkCanceled(this.tracker);
            int local = this.artifactOfFilesToCreate.size();
            int remote = this.artifactRequests.size();
            int old = this.filesToClean.size();
            int total = local + remote;
            if (total > 0 || old > 0) {
                Object object = total == 1 ? "1 file" : total + " files";
                this.tracker.setTaskName("update " + (String)object + " (download " + remote + ") in " + this.hostPlugin.getPluginName());
                SynchronizeMavenArtifact.this.info(this.log, "update " + total + " files (download " + remote + ") in '" + this.hostPlugin.getPluginName() + "'");
            }
            for (IResource iResource : this.filesToClean) {
                this.artifactsToRefresh.add(iResource);
                SynchronizeMavenArtifact.this.info(this.log, "remove old or suspect file: " + String.valueOf(iResource));
                iResource.getRawLocation().toFile().delete();
            }
            List<ArtifactResult> list = SynchronizeMavenArtifact.resolveArtifacts(this.log, this.system, this.session, this.artifactRequests);
            for (ArtifactResult artifactResult : list) {
                ArtifactRequest rq = artifactResult.getRequest();
                Artifact mvn = rq.getArtifact();
                String c = mvn.getClassifier();
                if (artifactResult.isMissing() || !artifactResult.isResolved() || !artifactResult.getExceptions().isEmpty()) {
                    if (SynchronizeMavenArtifact.CLASSIFIER_SOURCES.equals(c)) {
                        this.log.warn("No sources available for " + mvn.getGroupId() + ":" + mvn.getArtifactId() + ":" + mvn.getVersion());
                        continue;
                    }
                    String classifier = c == null || c.isEmpty() ? "" : ":" + c;
                    this.log.error("cannot resolve " + mvn.getGroupId() + ":" + mvn.getArtifactId() + classifier + ":" + mvn.getVersion());
                    continue;
                }
                Artifact artifact = artifactResult.getArtifact();
                File resolvedFile = artifact.getFile();
                IFile targetFile = this.targetFolder.getFile(resolvedFile.getName());
                this.artifactOfFilesToCreate.put(targetFile, artifact);
            }
            for (Map.Entry entry : this.artifactOfFilesToCreate.entrySet()) {
                IFile targetResource = (IFile)entry.getKey();
                this.artifactsToRefresh.add((IResource)targetResource);
                File targetFile = targetResource.getRawLocation().toFile();
                File resolvedFile = ((Artifact)entry.getValue()).getFile();
                SynchronizeMavenArtifact.this.updateFileInProjectsMavenFolder(this.log, targetFile, resolvedFile);
            }
        }

        void refreshWorkspace() throws CoreException {
            for (IResource r : this.artifactsToRefresh) {
                r.refreshLocal(0, null);
            }
        }
    }

    private static class Coordinate {
        final String group;
        final String artifact;
        final String extension;
        final String classifier;
        final String version;

        public Coordinate(String coord) {
            Matcher matcher = PluginBuild.MAVEN_COORDINATE_PATTERN.matcher(coord);
            if (!matcher.matches()) {
                throw new IllegalStateException("Illegal maven coordinates: " + coord);
            }
            this.group = matcher.group(1);
            this.artifact = matcher.group(2);
            this.extension = Coordinate.get(matcher.group(4), "jar");
            this.classifier = Coordinate.get(matcher.group(6), "");
            this.version = matcher.group(7);
        }

        private static String get(String value, String defaultValue) {
            return value == null || value.length() <= 0 ? defaultValue : value;
        }
    }

    private static class InternalWagonProvider
    implements WagonProvider {
        private InternalWagonProvider() {
        }

        public Wagon lookup(String roleHint) throws Exception {
            switch (roleHint) {
                case "file": {
                    return new FileWagon();
                }
                case "http": {
                    return InternalWagonProvider.newOfFirstWagonAvailable("org.apache.maven.wagon.providers.http.HttpWagon", "io.takari.aether.wagon.OkHttpWagon");
                }
                case "https": {
                    return InternalWagonProvider.newOfFirstWagonAvailable("org.apache.maven.wagon.providers.http.HttpWagon", "io.takari.aether.wagon.OkHttpsWagon");
                }
            }
            return null;
        }

        private static Wagon newOfFirstWagonAvailable(String ... classnames) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
            String classname = null;
            Constructor<?> constructor = null;
            String[] stringArray = classnames;
            int n = classnames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                try {
                    Class<?> candidate = Class.forName(name);
                    if (Wagon.class.isAssignableFrom(candidate)) {
                        classname = name;
                        constructor = candidate.getConstructor(new Class[0]);
                        break;
                    }
                }
                catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
                    // empty catch block
                }
                ++n2;
            }
            if (constructor != null) {
                try {
                    return (Wagon)constructor.newInstance(new Object[0]);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("constructing " + classname, e.getTargetException());
                }
            }
            ClassNotFoundException e = new ClassNotFoundException("one of " + String.join((CharSequence)", ", classnames));
            e.printStackTrace();
            throw e;
        }

        public void release(Wagon wagon) {
            if (wagon instanceof StreamWagon) {
                try {
                    ((StreamWagon)wagon).closeConnection();
                }
                catch (ConnectionException e) {
                    throw new RuntimeException("Cannot close connection", e);
                }
            }
        }
    }

    public static class MavenConfig {
        private static final String MAVEN_REPO_URL = "maven_repo_url_";
        private static final String MAVEN_REPO_TYPE = "maven_repo_type_";
        protected final Properties props;

        public MavenConfig(File file) throws IOException {
            try (FileInputStream fis = new FileInputStream(file);){
                this.props = new Properties();
                this.props.load(fis);
            }
        }

        public Properties getProps() {
            return this.props;
        }

        public Map<String, String> getMavenRepos() {
            long repoNum = 0L;
            TreeMap<String, String> result = new TreeMap<String, String>();
            for (String key : this.props.stringPropertyNames()) {
                if (key == null || !key.startsWith(MAVEN_REPO_URL)) continue;
                String type = this.props.getProperty(MAVEN_REPO_TYPE + key.substring(MAVEN_REPO_URL.length()));
                result.put(type + repoNum++, this.props.getProperty(key));
            }
            return result;
        }

        public boolean isVerboseMavenOutput() {
            String x = this.props.getProperty("maven_verbose");
            return Boolean.parseBoolean(x);
        }
    }
}

