/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis;

import java.nio.file.Path;
import java.util.function.Function;
import org.eclipse.set.basis.exceptions.NotWritable;
import org.eclipse.set.basis.extensions.PathExtensions;

public class OverwriteHandling {
    private final Method method;
    private final Function<Path, Boolean> overwriteConfirmation;

    public static OverwriteHandling forCheckbox(boolean selection) {
        return new OverwriteHandling(selection ? Method.OVERWRITE : Method.NO_OVERWRITE, null);
    }

    public static OverwriteHandling forUserConfirmation(Function<Path, Boolean> overwriteConfirmation) {
        return new OverwriteHandling(Method.ASK_USER, overwriteConfirmation);
    }

    private OverwriteHandling(Method method, Function<Path, Boolean> overwriteConfirmation) {
        this.method = method;
        this.overwriteConfirmation = overwriteConfirmation;
    }

    public boolean test(Path path) throws NotWritable {
        if (!path.toFile().exists()) {
            return true;
        }
        switch (this.method) {
            case NO_OVERWRITE: {
                return false;
            }
            case OVERWRITE: {
                PathExtensions.checkCanWrite(path);
                return true;
            }
            case ASK_USER: {
                return this.askUser(path);
            }
        }
        throw new IllegalArgumentException(this.method.toString());
    }

    private boolean askUser(Path path) throws NotWritable {
        boolean confirmed = this.overwriteConfirmation.apply(path);
        if (confirmed) {
            PathExtensions.checkCanWrite(path);
        }
        return confirmed;
    }

    private static enum Method {
        ASK_USER,
        NO_OVERWRITE,
        OVERWRITE;

    }
}

