/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.set.basis.DomainElementList;
import org.eclipse.set.basis.attachments.Attachment;
import org.eclipse.set.basis.attachments.AttachmentInfo;
import org.eclipse.set.basis.attachments.FileKind;
import org.eclipse.set.basis.files.AttachmentContentService;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.model.planpro.Basisobjekte.Anhang;
import org.eclipse.set.model.planpro.Basisobjekte.Anhang_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Anhang_Art_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.BasisobjektePackage;
import org.eclipse.set.model.planpro.Basisobjekte.Dateiname_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Dateityp_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.ENUMAnhangArt;
import org.eclipse.set.model.planpro.Basisobjekte.ENUMDateityp;
import org.eclipse.set.ppmodel.extensions.internal.AttachmentProxyList;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class AnhangTransformation {
    private final EnumTranslationService translationService;
    private final AttachmentContentService contentService;
    private final HashMap<ArrayList<?>, Attachment> _createCache_toAttachment = CollectionLiterals.newHashMap();

    public static AnhangTransformation createTransformation(EnumTranslationService translationService, AttachmentContentService contentService) {
        return new AnhangTransformation(translationService, contentService);
    }

    private AnhangTransformation(EnumTranslationService translationService, AttachmentContentService contentService) {
        this.translationService = translationService;
        this.contentService = contentService;
    }

    public List<Attachment> toAttachment(List<Anhang> anhaenge) {
        LinkedList attachments = Lists.newLinkedList();
        Functions.Function1 _function = it -> this.toAttachment((Anhang)it);
        attachments.addAll(ListExtensions.map(anhaenge, (Functions.Function1)_function));
        return attachments;
    }

    public DomainElementList<Attachment, AttachmentInfo<Attachment>> toAttachment(DomainElementList<Anhang, AttachmentInfo<Anhang>> anhaenge) {
        return new AttachmentProxyList(anhaenge, this.translationService, this.contentService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attachment toAttachment(Anhang anhang) {
        AnhangProxy _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Anhang[]{anhang});
        HashMap<ArrayList<?>, Attachment> hashMap = this._createCache_toAttachment;
        synchronized (hashMap) {
            AnhangProxy _anhangProxy;
            if (this._createCache_toAttachment.containsKey(_cacheKey)) {
                return this._createCache_toAttachment.get(_cacheKey);
            }
            _result = _anhangProxy = new AnhangProxy();
            this._createCache_toAttachment.put(_cacheKey, _result);
        }
        this._init_toAttachment(_result, anhang);
        return _result;
    }

    private void _init_toAttachment(AnhangProxy it, Anhang anhang) {
        it.anhang = anhang;
        it.transformation = this;
    }

    public FileKind toFileKind(Anhang anhang) {
        Anhang_Allg_AttributeGroup _anhangAllg = null;
        if (anhang != null) {
            _anhangAllg = anhang.getAnhangAllg();
        }
        Anhang_Art_TypeClass _anhangArt = null;
        if (_anhangAllg != null) {
            _anhangArt = _anhangAllg.getAnhangArt();
        }
        ENUMAnhangArt _wert = null;
        if (_anhangArt != null) {
            _wert = _anhangArt.getWert();
        }
        ENUMAnhangArt enumAnhangArt = _wert;
        int _value = enumAnhangArt.getValue();
        String _alternative = this.translationService.translate((Enumerator)enumAnhangArt).getAlternative();
        return new FileKind(_value, _alternative);
    }

    public static Boolean isPdf(Anhang anhang) {
        Anhang_Allg_AttributeGroup _anhangAllg = null;
        if (anhang != null) {
            _anhangAllg = anhang.getAnhangAllg();
        }
        Dateityp_TypeClass _dateityp = null;
        if (_anhangAllg != null) {
            _dateityp = _anhangAllg.getDateityp();
        }
        ENUMDateityp _wert = null;
        if (_dateityp != null) {
            _wert = _dateityp.getWert();
        }
        return Objects.equals(_wert, ENUMDateityp.ENUM_DATEITYP_PDF);
    }

    private static class AnhangProxy
    implements Attachment {
        @Accessors
        private Anhang anhang;
        @Accessors
        private AnhangTransformation transformation;

        private AnhangProxy() {
        }

        public String getBaseFilename() {
            Anhang_Allg_AttributeGroup _anhangAllg = null;
            if (this.anhang != null) {
                _anhangAllg = this.anhang.getAnhangAllg();
            }
            Dateiname_TypeClass _dateiname = null;
            if (_anhangAllg != null) {
                _dateiname = _anhangAllg.getDateiname();
            }
            String _wert = null;
            if (_dateiname != null) {
                _wert = _dateiname.getWert();
            }
            return _wert;
        }

        public byte[] getData() {
            try {
                return this.transformation.contentService.getContent(this.anhang);
            }
            catch (Throwable _t) {
                if (_t instanceof IOException) {
                    IOException e = (IOException)_t;
                    throw new RuntimeException(e);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }

        public String getFileExtension() {
            Anhang_Allg_AttributeGroup _anhangAllg = null;
            if (this.anhang != null) {
                _anhangAllg = this.anhang.getAnhangAllg();
            }
            Dateityp_TypeClass _dateityp = null;
            if (_anhangAllg != null) {
                _dateityp = _anhangAllg.getDateityp();
            }
            ENUMDateityp _wert = null;
            if (_dateityp != null) {
                _wert = _dateityp.getWert();
            }
            String _literal = null;
            if (_wert != null) {
                _literal = _wert.getLiteral();
            }
            return _literal;
        }

        public FileKind getFileKind() {
            return this.transformation.toFileKind(this.anhang);
        }

        public String getFullFilename() {
            StringConcatenation _builder = new StringConcatenation();
            String _baseFilename = this.getBaseFilename();
            _builder.append(_baseFilename);
            _builder.append(".");
            String _fileExtension = this.getFileExtension();
            _builder.append(_fileExtension);
            return _builder.toString();
        }

        public String getId() {
            return this.anhang.getIdentitaet().getWert();
        }

        public boolean isPdf() {
            Boolean _elvis = null;
            Boolean _isPdf = null;
            if (this.anhang != null) {
                _isPdf = AnhangTransformation.isPdf(this.anhang);
            }
            _elvis = _isPdf != null ? _isPdf : Boolean.valueOf(false);
            return _elvis;
        }

        public void setFileKind(FileKind fileKind) {
            EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.anhang);
            Command command = SetCommand.create((EditingDomain)editingDomain, (Object)this.anhang.getAnhangAllg().getAnhangArt(), (Object)BasisobjektePackage.eINSTANCE.getAnhang_Art_TypeClass_Wert(), (Object)ENUMAnhangArt.get((int)fileKind.getId()));
            editingDomain.getCommandStack().execute(command);
        }

        public Object getOriginal() {
            return this.anhang;
        }

        @Pure
        public Anhang getAnhang() {
            return this.anhang;
        }

        public void setAnhang(Anhang anhang) {
            this.anhang = anhang;
        }

        @Pure
        public AnhangTransformation getTransformation() {
            return this.transformation;
        }

        public void setTransformation(AnhangTransformation transformation) {
            this.transformation = transformation;
        }
    }
}

