/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.table;

import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.utils.table.ColumnAccessor;
import org.eclipse.set.utils.table.ColumnDescriptorModelBuilder;

public final class GroupBuilder {
    private final ColumnDescriptorModelBuilder builder;
    private final Float defaultColumnWidth;
    private final ColumnDescriptor groupRoot;

    public GroupBuilder(ColumnDescriptorModelBuilder builder, ColumnDescriptor parent) {
        this.builder = builder;
        this.groupRoot = parent;
        this.defaultColumnWidth = null;
    }

    public GroupBuilder(ColumnDescriptorModelBuilder builder, ColumnDescriptor parent, float defaultColumnWidth) {
        this.builder = builder;
        this.groupRoot = parent;
        this.defaultColumnWidth = Float.valueOf(defaultColumnWidth);
    }

    public ColumnAccessor add(ColumnDescriptor childDescriptor) {
        return this.handleDefaultColumnWidth(this.builder.addColumn(this.groupRoot, childDescriptor));
    }

    public void add(ColumnDescriptor ... childDescriptorList) {
        ColumnDescriptor[] columnDescriptorArray = childDescriptorList;
        int n = childDescriptorList.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDescriptor childDescriptor = columnDescriptorArray[n2];
            this.handleDefaultColumnWidth(this.builder.addColumn(this.groupRoot, childDescriptor));
            ++n2;
        }
    }

    public ColumnAccessor add(ColumnDescriptor childDescriptor, String unit) {
        return this.handleDefaultColumnWidth(this.builder.addColumnWithUnit(this.groupRoot, childDescriptor, unit));
    }

    public void add(float width, ColumnDescriptor ... childDescriptorList) {
        ColumnDescriptor[] columnDescriptorArray = childDescriptorList;
        int n = childDescriptorList.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDescriptor childDescriptor = columnDescriptorArray[n2];
            this.handleDefaultColumnWidth(this.builder.addColumn(this.groupRoot, childDescriptor)).width(width);
            ++n2;
        }
    }

    public GroupBuilder addGroup(String label) {
        return this.handleDefaultColumnWidth(this.builder.addGroup(this.groupRoot, label));
    }

    public GroupBuilder addGroup(String label, float defaultWidth) {
        return this.handleDefaultColumnWidth(this.builder.addGroup(this.groupRoot, label, defaultWidth));
    }

    public ColumnDescriptor getGroupRoot() {
        return this.groupRoot;
    }

    public GroupBuilder height(float height) {
        this.groupRoot.setHeight((double)height);
        return this;
    }

    public GroupBuilder width(float width) {
        this.groupRoot.setWidth(Float.valueOf(width));
        return this;
    }

    private ColumnAccessor handleDefaultColumnWidth(ColumnAccessor column) {
        if (this.defaultColumnWidth != null) {
            return column.width(this.defaultColumnWidth.floatValue());
        }
        return column;
    }

    private GroupBuilder handleDefaultColumnWidth(GroupBuilder group) {
        if (this.defaultColumnWidth != null) {
            return group.width(this.defaultColumnWidth.floatValue());
        }
        return group;
    }
}

