/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.table;

import jakarta.inject.Inject;
import java.util.LinkedList;
import java.util.List;
import java.util.function.IntPredicate;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.set.application.Messages;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.part.ToolboxPartService;
import org.eclipse.set.utils.events.JumpToSiteplanEvent;
import org.eclipse.set.utils.events.JumpToSourceLineEvent;
import org.eclipse.set.utils.events.JumpToTableEvent;
import org.eclipse.set.utils.events.ToolboxEvent;
import org.eclipse.set.utils.events.ToolboxEvents;
import org.eclipse.set.utils.table.TableInfo;
import org.eclipse.set.utils.table.menu.TableBodyMenuConfiguration;
import org.eclipse.set.utils.table.menu.TableMenuService;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class TableMenuServiceImpl
implements TableMenuService {
    private static final String SOURCE_TEXT_VIEWER_PART_ID = "org.eclipse.set.application.descriptions.SourceWebTextViewDescriptionService";
    private static final String SITE_PLAN_PART_ID = "org.eclipse.set.feature.siteplan.descriptions.WebSiteplanDescriptionService";
    @Inject
    ToolboxPartService toolboxPartService;
    @Inject
    @Translation
    Messages messages;
    @Inject
    protected IEventBroker broker;
    protected List<TableBodyMenuConfiguration.TableBodyMenuItem> menuItems = new LinkedList<TableBodyMenuConfiguration.TableBodyMenuItem>();

    public TableBodyMenuConfiguration createMenuConfiguration(NatTable natTable, SelectionLayer selectionLayer) {
        return new TableBodyMenuConfiguration(natTable, selectionLayer, this.menuItems);
    }

    public void addMenuItem(TableBodyMenuConfiguration.TableBodyMenuItem menuItem) {
        this.menuItems.add(menuItem);
    }

    public List<TableBodyMenuConfiguration.TableBodyMenuItem> getMenuItems() {
        return this.menuItems;
    }

    public TableBodyMenuConfiguration.TableBodyMenuItem createShowInTextViewItem(final JumpToSourceLineEvent toolboxEvent, final SelectionLayer selectionlayer, IntPredicate enablePredicate) {
        return new TableBodyMenuConfiguration.TableBodyMenuItem(this.messages.TableMenuService_TextView, selectionlayer, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (selectionlayer.getSelectedCells().isEmpty()) {
                    return;
                }
                TableMenuServiceImpl.this.toolboxPartService.showPart(TableMenuServiceImpl.SOURCE_TEXT_VIEWER_PART_ID);
                ToolboxEvents.send((IEventBroker)TableMenuServiceImpl.this.broker, (ToolboxEvent)toolboxEvent);
            }
        }, enablePredicate);
    }

    public TableBodyMenuConfiguration.TableBodyMenuItem createShowInSitePlanItem(final JumpToSiteplanEvent jumpEvent, final SelectionLayer selectionlayer, IntPredicate enablePredicate) {
        return new TableBodyMenuConfiguration.TableBodyMenuItem(this.messages.TableMenuService_Siteplan, selectionlayer, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (selectionlayer.getSelectedCells().isEmpty()) {
                    return;
                }
                TableMenuServiceImpl.this.toolboxPartService.showPart(TableMenuServiceImpl.SITE_PLAN_PART_ID);
                if (Services.getSiteplanService().isNotFirstTimeOpenSiteplan()) {
                    ToolboxEvents.send((IEventBroker)TableMenuServiceImpl.this.broker, (ToolboxEvent)jumpEvent);
                } else {
                    TableMenuServiceImpl.this.broker.subscribe("siteplan/open", TableMenuServiceImpl.this.handleSiteplanLoadingEvent(jumpEvent));
                }
            }
        }, enablePredicate);
    }

    public TableBodyMenuConfiguration.TableBodyMenuItem createShowInTableItem(final JumpToTableEvent jumpEvent, final SelectionLayer selectionLayer, IntPredicate enablePredicate) {
        return new TableBodyMenuConfiguration.TableBodyMenuItem(this.messages.TableMenuService_Table, selectionLayer, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String tableShortcut = jumpEvent.getTableShortcut();
                if (selectionLayer.getSelectedCells().isEmpty() || tableShortcut == null || tableShortcut.isEmpty()) {
                    return;
                }
                String tableIdPrefix = "org.eclipse.set.feature.table.estw";
                if (jumpEvent.getTableCategory().equals(TableInfo.Pt1TableCategory.ETCS.getId())) {
                    tableIdPrefix = "org.eclipse.set.feature.table.etcs";
                }
                TableMenuServiceImpl.this.toolboxPartService.showPart(tableIdPrefix + "." + tableShortcut.toLowerCase());
                ToolboxEvents.send((IEventBroker)TableMenuServiceImpl.this.broker, (ToolboxEvent)jumpEvent);
            }
        }, enablePredicate);
    }

    private EventHandler handleSiteplanLoadingEvent(final JumpToSiteplanEvent jumpEvent) {
        return new EventHandler(){

            public void handleEvent(Event event) {
                Boolean isLoading;
                Object object;
                if (event.getTopic().equals("siteplan/open") && (object = event.getProperty("org.eclipse.e4.data")) instanceof Boolean && !(isLoading = (Boolean)object).booleanValue()) {
                    ToolboxEvents.send((IEventBroker)TableMenuServiceImpl.this.broker, (ToolboxEvent)jumpEvent);
                    TableMenuServiceImpl.this.broker.unsubscribe((EventHandler)this);
                }
            }
        };
    }
}

