/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.pt1.ssks;

import com.google.common.collect.Streams;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.Pair;
import org.eclipse.set.basis.geometry.GeoPosition;
import org.eclipse.set.model.planpro.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.model.planpro.Geodaten.GEO_Kante;
import org.eclipse.set.model.planpro.Signale.ENUMBefestigungArt;
import org.eclipse.set.model.planpro.Signale.Signal;
import org.eclipse.set.model.planpro.Signale.Signal_Befestigung;
import org.eclipse.set.model.planpro.Signale.Signal_Rahmen;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.EObjectExtensions;
import org.eclipse.set.ppmodel.extensions.GeoKanteExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektTopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.SignalExtensions;
import org.eclipse.set.ppmodel.extensions.SignalRahmenExtensions;
import org.eclipse.set.ppmodel.extensions.geometry.GEOKanteGeometryExtensions;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;

public class SignalSideDistance {
    private final List<ENUMBefestigungArt> relevantMastType = List.of(ENUMBefestigungArt.ENUM_BEFESTIGUNG_ART_REGELANORDNUNG_MAST_HOCH, ENUMBefestigungArt.ENUM_BEFESTIGUNG_ART_REGELANORDNUNG_MAST_NIEDRIG, ENUMBefestigungArt.ENUM_BEFESTIGUNG_ART_REGELANORDNUNG_SONSTIGE_HOCH, ENUMBefestigungArt.ENUM_BEFESTIGUNG_ART_REGELANORDNUNG_SONSTIGE_NIEDRIG, ENUMBefestigungArt.ENUM_BEFESTIGUNG_ART_SONDERANORDNUNG_MAST_HOCH, ENUMBefestigungArt.ENUM_BEFESTIGUNG_ART_SONDERANORDNUNG_MAST_NIEDRIG, ENUMBefestigungArt.ENUM_BEFESTIGUNG_ART_PFOSTEN_HOCH, ENUMBefestigungArt.ENUM_BEFESTIGUNG_ART_PFOSTEN_NIEDRIG, ENUMBefestigungArt.ENUM_BEFESTIGUNG_ART_ARBEITSBUEHNE, ENUMBefestigungArt.ENUM_BEFESTIGUNG_ART_OL_MAST, ENUMBefestigungArt.ENUM_BEFESTIGUNG_ART_WAND, ENUMBefestigungArt.ENUM_BEFESTIGUNG_ART_DACH_DECKE);
    final Signal signal;
    private final Set<SideDistance> sideDistancesRight = new HashSet<SideDistance>();
    private final Set<SideDistance> sideDistancesLeft = new HashSet<SideDistance>();
    private static final long MAX_DISTANCE_TO_NEIGHBOR = 8000L;

    public SignalSideDistance(Signal signal) {
        this.signal = signal;
        this.getSideDistance();
    }

    public Set<SideDistance> getSideDistancesRight() {
        return this.sideDistancesRight;
    }

    public Set<SideDistance> getSideDistancesLeft() {
        return this.sideDistancesLeft;
    }

    private void getSideDistance() throws IllegalArgumentException, NullPointerException, RuntimeException {
        Set<Signal_Befestigung> signalBefestigung = this.getSignalBefestigung();
        Set<Punkt_Objekt_TOP_Kante_AttributeGroup> potks = signalBefestigung.stream().flatMap(befestigung -> PunktObjektExtensions.getSinglePoints((Punkt_Objekt)befestigung).stream().filter(Objects::nonNull)).collect(Collectors.toSet());
        potks.forEach(potk -> {
            double signalRotation;
            ENUMWirkrichtung direction = PunktObjektExtensions.getSinglePoint((Punkt_Objekt)this.signal).getWirkrichtung().getWert();
            Pair<Long, Long> result = SignalSideDistance.getSideDistance(potk, direction, signalRotation = PunktObjektExtensions.rotation((Punkt_Objekt)this.signal));
            if (result == null) {
                return;
            }
            this.setSideDistances((Long)result.getFirst(), direction, (Long)result.getSecond());
        });
    }

    public static Pair<Long, Long> getSideDistance(Punkt_Objekt_TOP_Kante_AttributeGroup potk, ENUMWirkrichtung direction, double rotation) {
        Long sideDistance = EObjectExtensions.getNullableObject((Object)potk, p -> Math.round(p.getSeitlicherAbstand().getWert().doubleValue() * 1000.0)).orElse(null);
        if (sideDistance == null) {
            return null;
        }
        long distanceFromPoint = 8000L - Math.abs(sideDistance);
        int perpendicularRotation = SignalSideDistance.getPerpendicularRotation(sideDistance, direction);
        if (distanceFromPoint <= 0L) {
            return new Pair((Object)sideDistance, (Object)0L);
        }
        double opposideDistance = 0.0;
        GeoPosition position = PunktObjektTopKanteExtensions.getCoordinate((Punkt_Objekt_TOP_Kante_AttributeGroup)potk);
        try {
            opposideDistance = SignalSideDistance.getOpposideDistance(potk, position, rotation + (double)perpendicularRotation, (float)distanceFromPoint / 1000.0f);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        long distanceBetweenTrack = opposideDistance > 0.0 ? Math.abs(sideDistance) + Math.round(opposideDistance * 1000.0) : 0L;
        return new Pair((Object)sideDistance, (Object)distanceBetweenTrack);
    }

    private Set<Signal_Befestigung> getSignalBefestigung() {
        return SignalExtensions.signalRahmen((Signal)this.signal).stream().map(rahmen -> {
            Iterator signalBefestigungIterator = SignalRahmenExtensions.getSignalBefestigungIterator((Signal_Rahmen)rahmen);
            return Streams.stream((Iterator)signalBefestigungIterator).filter(befestigung -> {
                ENUMBefestigungArt befestigungArt = EObjectExtensions.getNullableObject((Object)befestigung, e -> e.getSignalBefestigungAllg().getBefestigungArt().getWert()).orElse(null);
                return befestigungArt != null && this.relevantMastType.contains(befestigungArt);
            }).findFirst().orElse(null);
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static int getPerpendicularRotation(long sideDistance, ENUMWirkrichtung direction) throws IllegalArgumentException {
        boolean isPositiveSideDistance = sideDistance >= 0L;
        switch (direction) {
            case ENUM_WIRKRICHTUNG_IN: {
                return isPositiveSideDistance ? 90 : -90;
            }
            case ENUM_WIRKRICHTUNG_GEGEN: {
                return isPositiveSideDistance ? -90 : 90;
            }
        }
        throw new IllegalArgumentException("The Punkt_Objekt have Illegal Wirkrichtung: " + String.valueOf(direction));
    }

    private static double getOpposideDistance(Punkt_Objekt_TOP_Kante_AttributeGroup potk, GeoPosition position, double angle, double maxDistance) {
        double rad = angle * Math.PI / 180.0;
        double transformX = Math.sin(rad) * maxDistance + position.getCoordinate().x;
        double transformY = Math.cos(rad) * maxDistance + position.getCoordinate().y;
        GeometryFactory geometryFactory = new GeometryFactory();
        LineString perpendicularLine = geometryFactory.createLineString(new Coordinate[]{position.getCoordinate(), new Coordinate(transformX, transformY)});
        List<LineString> relevantGeometries = Streams.stream((Iterable)BasisAttributExtensions.getContainer((EObject)potk).getGEOKante()).filter(geoKante -> GeoKanteExtensions.topKante((GEO_Kante)geoKante) != null).filter(geoKante -> GeoKanteExtensions.topKante((GEO_Kante)geoKante) != potk.getIDTOPKante().getValue()).map(GEOKanteGeometryExtensions::getGeometry).filter(Objects::nonNull).toList();
        return SignalSideDistance.getOpposideDistance(relevantGeometries, perpendicularLine, position);
    }

    private static double getOpposideDistance(List<LineString> relevantGeometries, LineString perpendicularLine, GeoPosition position) {
        List<Geometry> intersctionPoints = relevantGeometries.stream().filter(geometry -> geometry.intersects((Geometry)perpendicularLine)).map(geometry -> geometry.intersection((Geometry)perpendicularLine)).toList();
        List<Double> distances = intersctionPoints.stream().map(point -> point.getCoordinate().distance(position.getCoordinate())).toList();
        return distances.stream().min(Double::compare).orElse(0.0);
    }

    private void setSideDistances(long sideDistance, ENUMWirkrichtung direction, long distanceBetweenTracks) throws IllegalArgumentException {
        boolean isPositiveSideDistance = sideDistance >= 0L;
        long positiveSideDistance = Math.abs(sideDistance);
        switch (direction) {
            case ENUM_WIRKRICHTUNG_IN: {
                if (isPositiveSideDistance) {
                    this.sideDistancesLeft.add(new SideDistance(positiveSideDistance, distanceBetweenTracks));
                    break;
                }
                this.sideDistancesRight.add(new SideDistance(positiveSideDistance, distanceBetweenTracks));
                break;
            }
            case ENUM_WIRKRICHTUNG_GEGEN: {
                if (!isPositiveSideDistance) {
                    this.sideDistancesLeft.add(new SideDistance(positiveSideDistance, distanceBetweenTracks));
                    break;
                }
                this.sideDistancesRight.add(new SideDistance(positiveSideDistance, distanceBetweenTracks));
                break;
            }
            default: {
                throw new IllegalArgumentException("The Signal_Befestigung have Illegal Wirkrichtung: " + String.valueOf(direction));
            }
        }
    }

    public static class SideDistance {
        long distanceToMainTrack;
        long distanceToNeighborTrack;

        public double getDistanceToMainTrack() {
            return this.distanceToMainTrack;
        }

        public double getDistanceToNeighborTrack() {
            return this.distanceToNeighborTrack;
        }

        public SideDistance(long distanceToMainTrack, long distanceToNeighborTrack) {
            this.distanceToMainTrack = distanceToMainTrack;
            this.distanceToNeighborTrack = distanceToNeighborTrack;
        }

        public String toString() {
            if (this.distanceToNeighborTrack > 0L) {
                return String.format("%s (%s)", String.valueOf(this.distanceToMainTrack), String.valueOf(this.distanceToNeighborTrack));
            }
            return String.valueOf(this.distanceToMainTrack);
        }
    }
}

